/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client;

import io.ap4k.deps.kubernetes.api.model.RootPaths;
import io.ap4k.deps.kubernetes.client.Adapters;
import io.ap4k.deps.kubernetes.client.Client;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.ConfigBuilder;
import io.ap4k.deps.kubernetes.client.ExtensionAdapter;
import io.ap4k.deps.kubernetes.client.HttpClientAware;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.dsl.base.BaseOperation;
import io.ap4k.deps.kubernetes.client.utils.HttpClientUtils;
import io.ap4k.deps.kubernetes.client.utils.Utils;
import io.ap4k.deps.okhttp3.ConnectionPool;
import io.ap4k.deps.okhttp3.Dispatcher;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;

public abstract class BaseClient
implements Client,
HttpClientAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseClient.class);
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) throws KubernetesClientException {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        Utils.shutdownExecutorService(executorService);
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(this.httpClient, this.configuration, null, null, "", null, null, false, null, null, false, RootPaths.class, null, null){}.getRootPaths();
    }

    @Override
    public boolean supportsApiPath(String apiPath) {
        List<String> paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }
}

