/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.dsl.internal;

import io.ap4k.deps.kubernetes.api.model.LabelSelectorRequirement;
import io.ap4k.deps.kubernetes.api.model.PodList;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.ap4k.deps.kubernetes.api.model.apps.DoneableReplicaSet;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSet;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetFluent;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetList;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetSpecFluent;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.ap4k.deps.kubernetes.client.dsl.Operation;
import io.ap4k.deps.kubernetes.client.dsl.RollableScalableResource;
import io.ap4k.deps.kubernetes.client.dsl.internal.ReplicaSetOperationsImpl;
import io.ap4k.deps.kubernetes.client.dsl.internal.RollingUpdater;
import io.ap4k.deps.okhttp3.OkHttpClient;

class ReplicaSetRollingUpdater
extends RollingUpdater<ReplicaSet, ReplicaSetList, DoneableReplicaSet> {
    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicaSet createClone(ReplicaSet obj, String newName, String newDeploymentHash) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)((ReplicaSetFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)((ReplicaSetFluent.MetadataNested)new ReplicaSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(ReplicaSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected void updateDeploymentKey(DoneableReplicaSet obj, String hash) {
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)obj.editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableReplicaSet obj) {
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)obj.editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(ReplicaSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicaSet setReplicas(ReplicaSet obj, int replicas) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)new ReplicaSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, RollableScalableResource<ReplicaSet, DoneableReplicaSet>> resources() {
        return new ReplicaSetOperationsImpl(this.client, this.config, this.namespace);
    }
}

