/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.dsl.internal;

import io.ap4k.deps.kubernetes.api.model.LabelSelectorRequirement;
import io.ap4k.deps.kubernetes.api.model.PodList;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.ap4k.deps.kubernetes.api.model.apps.DoneableStatefulSet;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSet;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetBuilder;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetFluent;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetList;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.ap4k.deps.kubernetes.client.dsl.Operation;
import io.ap4k.deps.kubernetes.client.dsl.RollableScalableResource;
import io.ap4k.deps.kubernetes.client.dsl.internal.RollingUpdater;
import io.ap4k.deps.kubernetes.client.dsl.internal.StatefulSetOperationsImpl;
import io.ap4k.deps.okhttp3.OkHttpClient;

class StatefulSetRollingUpdater
extends RollingUpdater<StatefulSet, StatefulSetList, DoneableStatefulSet> {
    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected StatefulSet createClone(StatefulSet obj, String newName, String newDeploymentHash) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)((StatefulSetFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(StatefulSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected void updateDeploymentKey(DoneableStatefulSet obj, String hash) {
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)obj.editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableStatefulSet obj) {
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)obj.editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(StatefulSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected StatefulSet setReplicas(StatefulSet obj, int replicas) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)new StatefulSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<StatefulSet, StatefulSetList, DoneableStatefulSet, RollableScalableResource<StatefulSet, DoneableStatefulSet>> resources() {
        return new StatefulSetOperationsImpl(this.client, this.config, this.namespace);
    }
}

