/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.handlers;

import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.Handlers;
import io.ap4k.deps.kubernetes.client.ResourceHandler;
import io.ap4k.deps.kubernetes.client.Watch;
import io.ap4k.deps.kubernetes.client.Watcher;
import io.ap4k.deps.kubernetes.client.dsl.internal.KubernetesListOperationsImpl;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Component;

@Component
@org.apache.felix.scr.annotations.Service
public class KubernetesListHandler
implements ResourceHandler<KubernetesList, KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesListHandler.class);

    @Override
    public String getKind() {
        return Service.class.getSimpleName();
    }

    @Override
    public KubernetesList create(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, true, false, false, item, null).create(new KubernetesList[0]);
    }

    @Override
    public KubernetesList replace(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.replace(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesList reload(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.reload(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesListBuilder edit(KubernetesList item) {
        return new KubernetesListBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, true, false, false, item, null).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, String resourceVersion, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public KubernetesList waitUntilReady(OkHttpClient client, Config config, String namespace, KubernetesList item, long amount, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }
}

