/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.internal.readiness;

import io.ap4k.deps.kubernetes.api.model.EndpointSubset;
import io.ap4k.deps.kubernetes.api.model.Endpoints;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.Node;
import io.ap4k.deps.kubernetes.api.model.NodeCondition;
import io.ap4k.deps.kubernetes.api.model.Pod;
import io.ap4k.deps.kubernetes.api.model.PodCondition;
import io.ap4k.deps.kubernetes.api.model.ReplicationController;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerSpec;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerStatus;
import io.ap4k.deps.kubernetes.api.model.apps.Deployment;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentSpec;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentStatus;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSet;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetSpec;
import io.ap4k.deps.kubernetes.api.model.apps.ReplicaSetStatus;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSet;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetSpec;
import io.ap4k.deps.kubernetes.api.model.apps.StatefulSetStatus;
import io.ap4k.deps.kubernetes.client.utils.Utils;
import io.ap4k.deps.openshift.api.model.DeploymentConfig;
import io.ap4k.deps.openshift.api.model.DeploymentConfigSpec;
import io.ap4k.deps.openshift.api.model.DeploymentConfigStatus;

public class Readiness {
    private static final String POD_READY = "Ready";
    private static final String NODE_READY = "Ready";
    private static final String TRUE = "True";

    public static boolean isReadinessApplicable(Class<? extends HasMetadata> itemClass) {
        return Deployment.class.isAssignableFrom(itemClass) || ReplicaSet.class.isAssignableFrom(itemClass) || Pod.class.isAssignableFrom(itemClass) || DeploymentConfig.class.isAssignableFrom(itemClass) || ReplicationController.class.isAssignableFrom(itemClass) || Endpoints.class.isAssignableFrom(itemClass) || Node.class.isAssignableFrom(itemClass) || StatefulSet.class.isAssignableFrom(itemClass);
    }

    public static boolean isReady(HasMetadata item) {
        if (item instanceof Deployment) {
            return Readiness.isDeploymentReady((Deployment)item);
        }
        if (item instanceof ReplicaSet) {
            return Readiness.isReplicaSetReady((ReplicaSet)item);
        }
        if (item instanceof Pod) {
            return Readiness.isPodReady((Pod)item);
        }
        if (item instanceof DeploymentConfig) {
            return Readiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        if (item instanceof ReplicationController) {
            return Readiness.isReplicationControllerReady((ReplicationController)item);
        }
        if (item instanceof Endpoints) {
            return Readiness.isEndpointsReady((Endpoints)item);
        }
        if (item instanceof Node) {
            return Readiness.isNodeReady((Node)item);
        }
        if (item instanceof StatefulSet) {
            return Readiness.isStatefulSetReady((StatefulSet)item);
        }
        throw new IllegalArgumentException("Item needs to be one of [Node, Deployment, ReplicaSet, StatefulSet, Pod, DeploymentConfig, ReplicationController], but was: [" + item != null ? item.getKind() : "Unknown (null)]");
    }

    public static boolean isStatefulSetReady(StatefulSet ss) {
        Utils.checkNotNull(ss, "StatefulSet can't be null.");
        StatefulSetSpec spec = ss.getSpec();
        StatefulSetStatus status = ss.getStatus();
        if (status == null || status.getReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue();
    }

    public static boolean isDeploymentReady(Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentSpec spec = d.getSpec();
        DeploymentStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isReplicaSetReady(ReplicaSet r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicaSetSpec spec = r.getSpec();
        ReplicaSetStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isReplicationControllerReady(ReplicationController r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicationControllerSpec spec = r.getSpec();
        ReplicationControllerStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isEndpointsReady(Endpoints e) {
        Utils.checkNotNull(e, "Endpoints can't be null.");
        String name = e.getMetadata().getName();
        Utils.checkNotNull(name, "Endpoints name can't be null.");
        if (e.getSubsets() == null) {
            return false;
        }
        for (EndpointSubset subset : e.getSubsets()) {
            if (subset.getAddresses().isEmpty() || subset.getPorts().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPodReady(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        PodCondition condition = Readiness.getPodReadyCondition(pod);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static PodCondition getPodReadyCondition(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        if (pod.getStatus() == null || pod.getStatus().getConditions() == null) {
            return null;
        }
        for (PodCondition condition : pod.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    public static boolean isNodeReady(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        NodeCondition condition = Readiness.getNodeReadyCondition(node);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static NodeCondition getNodeReadyCondition(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        if (node.getStatus() == null || node.getStatus().getConditions() == null) {
            return null;
        }
        for (NodeCondition condition : node.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }
}

