/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.osgi;

import io.ap4k.deps.kubernetes.api.model.ComponentStatus;
import io.ap4k.deps.kubernetes.api.model.ComponentStatusList;
import io.ap4k.deps.kubernetes.api.model.ConfigMap;
import io.ap4k.deps.kubernetes.api.model.ConfigMapList;
import io.ap4k.deps.kubernetes.api.model.Doneable;
import io.ap4k.deps.kubernetes.api.model.DoneableComponentStatus;
import io.ap4k.deps.kubernetes.api.model.DoneableConfigMap;
import io.ap4k.deps.kubernetes.api.model.DoneableEndpoints;
import io.ap4k.deps.kubernetes.api.model.DoneableEvent;
import io.ap4k.deps.kubernetes.api.model.DoneableLimitRange;
import io.ap4k.deps.kubernetes.api.model.DoneableNamespace;
import io.ap4k.deps.kubernetes.api.model.DoneableNode;
import io.ap4k.deps.kubernetes.api.model.DoneablePersistentVolume;
import io.ap4k.deps.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.ap4k.deps.kubernetes.api.model.DoneablePod;
import io.ap4k.deps.kubernetes.api.model.DoneableReplicationController;
import io.ap4k.deps.kubernetes.api.model.DoneableResourceQuota;
import io.ap4k.deps.kubernetes.api.model.DoneableSecret;
import io.ap4k.deps.kubernetes.api.model.DoneableService;
import io.ap4k.deps.kubernetes.api.model.DoneableServiceAccount;
import io.ap4k.deps.kubernetes.api.model.Endpoints;
import io.ap4k.deps.kubernetes.api.model.EndpointsList;
import io.ap4k.deps.kubernetes.api.model.Event;
import io.ap4k.deps.kubernetes.api.model.EventList;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesResourceList;
import io.ap4k.deps.kubernetes.api.model.LimitRange;
import io.ap4k.deps.kubernetes.api.model.LimitRangeList;
import io.ap4k.deps.kubernetes.api.model.Namespace;
import io.ap4k.deps.kubernetes.api.model.NamespaceList;
import io.ap4k.deps.kubernetes.api.model.Node;
import io.ap4k.deps.kubernetes.api.model.NodeList;
import io.ap4k.deps.kubernetes.api.model.PersistentVolume;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeClaim;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeClaimList;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeList;
import io.ap4k.deps.kubernetes.api.model.Pod;
import io.ap4k.deps.kubernetes.api.model.PodList;
import io.ap4k.deps.kubernetes.api.model.ReplicationController;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerList;
import io.ap4k.deps.kubernetes.api.model.ResourceQuota;
import io.ap4k.deps.kubernetes.api.model.ResourceQuotaList;
import io.ap4k.deps.kubernetes.api.model.RootPaths;
import io.ap4k.deps.kubernetes.api.model.Secret;
import io.ap4k.deps.kubernetes.api.model.SecretList;
import io.ap4k.deps.kubernetes.api.model.ServiceAccount;
import io.ap4k.deps.kubernetes.api.model.ServiceAccountList;
import io.ap4k.deps.kubernetes.api.model.ServiceList;
import io.ap4k.deps.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.ap4k.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.ap4k.deps.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
import io.ap4k.deps.kubernetes.client.Adapters;
import io.ap4k.deps.kubernetes.client.BaseClient;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.ConfigBuilder;
import io.ap4k.deps.kubernetes.client.DefaultKubernetesClient;
import io.ap4k.deps.kubernetes.client.ExtensionAdapter;
import io.ap4k.deps.kubernetes.client.Handlers;
import io.ap4k.deps.kubernetes.client.KubernetesClient;
import io.ap4k.deps.kubernetes.client.NamespacedKubernetesClient;
import io.ap4k.deps.kubernetes.client.RequestConfig;
import io.ap4k.deps.kubernetes.client.ResourceHandler;
import io.ap4k.deps.kubernetes.client.VersionInfo;
import io.ap4k.deps.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.FunctionCallable;
import io.ap4k.deps.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.ap4k.deps.kubernetes.client.dsl.MixedOperation;
import io.ap4k.deps.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.ap4k.deps.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.PodResource;
import io.ap4k.deps.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.Resource;
import io.ap4k.deps.kubernetes.client.dsl.RollableScalableResource;
import io.ap4k.deps.kubernetes.client.dsl.ServiceResource;
import io.ap4k.deps.kubernetes.client.dsl.StorageAPIGroupDSL;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.ap4k.deps.kubernetes.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        if (properties.containsKey("kubernetes.truststore.file")) {
            builder.withTrustStoreFile((String)properties.get("kubernetes.truststore.file"));
        }
        if (properties.containsKey("kubernetes.truststore.passphrase")) {
            builder.withTrustStorePassphrase((String)properties.get("kubernetes.truststore.passphrase"));
        }
        if (properties.containsKey("kubernetes.keystore.file")) {
            builder.withKeyStoreFile((String)properties.get("kubernetes.keystore.file"));
        }
        if (properties.containsKey("kubernetes.keystore.passphrase")) {
            builder.withKeyStorePassphrase((String)properties.get("kubernetes.keystore.passphrase"));
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<io.ap4k.deps.kubernetes.api.model.Service, ServiceList, DoneableService, ServiceResource<io.ap4k.deps.kubernetes.api.model.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return this.delegate.customResourceDefinitions();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.delegate.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }
}

