/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpec;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.ap4k.deps.openshift.api.model.DeploymentConfigSpec;
import io.ap4k.deps.openshift.api.model.DeploymentConfigSpecFluent;
import io.ap4k.deps.openshift.api.model.DeploymentStrategy;
import io.ap4k.deps.openshift.api.model.DeploymentStrategyBuilder;
import io.ap4k.deps.openshift.api.model.DeploymentStrategyFluentImpl;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicy;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeploymentConfigSpecFluentImpl<A extends DeploymentConfigSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private Map<String, String> selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;
    private Boolean test;
    private List<DeploymentTriggerPolicyBuilder> triggers;

    public DeploymentConfigSpecFluentImpl() {
    }

    public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public A withNewMinReadySeconds(String arg1) {
        return this.withMinReadySeconds(new Integer(arg1));
    }

    @Override
    public A withNewMinReadySeconds(int arg1) {
        return this.withMinReadySeconds(new Integer(arg1));
    }

    @Override
    public Boolean isPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    public A withNewPaused(String arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    public A withNewPaused(boolean arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A withNewReplicas(String arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReplicas(int arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    public A withNewRevisionHistoryLimit(String arg1) {
        return this.withRevisionHistoryLimit(new Integer(arg1));
    }

    @Override
    public A withNewRevisionHistoryLimit(int arg1) {
        return this.withRevisionHistoryLimit(new Integer(arg1));
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.remove(this.strategy);
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new DeploymentStrategyBuilder().build());
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public Boolean isTest() {
        return this.test;
    }

    @Override
    public A withTest(Boolean test) {
        this.test = test;
        return (A)this;
    }

    @Override
    public Boolean hasTest() {
        return this.test != null;
    }

    @Override
    public A withNewTest(String arg1) {
        return this.withTest(new Boolean(arg1));
    }

    @Override
    public A withNewTest(boolean arg1) {
        return this.withTest(new Boolean(arg1));
    }

    @Override
    public A addToTriggers(int index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.triggers.add(index >= 0 ? index : this.triggers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggers(int index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.triggers.size()) {
            this.triggers.add(builder);
        } else {
            this.triggers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggers(DeploymentTriggerPolicy ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentTriggerPolicy> getTriggers() {
        return DeploymentConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public List<DeploymentTriggerPolicy> buildTriggers() {
        return DeploymentConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public DeploymentTriggerPolicy buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    @Override
    public DeploymentTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    @Override
    public DeploymentTriggerPolicy buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    @Override
    public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        for (DeploymentTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
        if (this.triggers != null) {
            this._visitables.removeAll(this.triggers);
        }
        if (triggers != null) {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withTriggers(DeploymentTriggerPolicy ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
        }
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(-1, item);
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index, DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(index, item);
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(int index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException("Can't edit first triggers. The list is empty.");
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggers. The list is empty.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.apply(this.triggers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggers. No match found.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.test != null ? !this.test.equals(that.test) : that.test != null) {
            return false;
        }
        return !(this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null);
    }

    public class TriggersNestedImpl<N>
    extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>>
    implements DeploymentConfigSpecFluent.TriggersNested<N>,
    Nested<N> {
        private final DeploymentTriggerPolicyBuilder builder;
        private final int index;

        TriggersNestedImpl(int index, DeploymentTriggerPolicy item) {
            this.index = index;
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        TriggersNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentTriggerPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.setToTriggers(this.index, this.builder.build());
        }

        @Override
        public N endTrigger() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>>
    implements DeploymentConfigSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.StrategyNested<N>>
    implements DeploymentConfigSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }
}

