/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.EnvVar;
import io.ap4k.deps.kubernetes.api.model.EnvVarBuilder;
import io.ap4k.deps.kubernetes.api.model.EnvVarFluentImpl;
import io.ap4k.deps.kubernetes.api.model.LocalObjectReference;
import io.ap4k.deps.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.ap4k.deps.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.ap4k.deps.kubernetes.api.model.ObjectReference;
import io.ap4k.deps.kubernetes.api.model.ObjectReferenceBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.ap4k.deps.openshift.api.model.DockerBuildStrategy;
import io.ap4k.deps.openshift.api.model.DockerBuildStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>>
extends BaseFluent<A>
implements DockerBuildStrategyFluent<A> {
    private List<EnvVarBuilder> buildArgs;
    private String dockerfilePath;
    private List<EnvVarBuilder> env;
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private String imageOptimizationPolicy;
    private Boolean noCache;
    private LocalObjectReferenceBuilder pullSecret;

    public DockerBuildStrategyFluentImpl() {
    }

    public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance) {
        this.withBuildArgs(instance.getBuildArgs());
        this.withDockerfilePath(instance.getDockerfilePath());
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy());
        this.withNoCache(instance.getNoCache());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public A addToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.buildArgs.add(index >= 0 ? index : this.buildArgs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.buildArgs.size()) {
            this.buildArgs.add(builder);
        } else {
            this.buildArgs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.buildArgs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.buildArgs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBuildArgs(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getBuildArgs() {
        return DockerBuildStrategyFluentImpl.build(this.buildArgs);
    }

    @Override
    public List<EnvVar> buildBuildArgs() {
        return DockerBuildStrategyFluentImpl.build(this.buildArgs);
    }

    @Override
    public EnvVar buildBuildArg(int index) {
        return this.buildArgs.get(index).build();
    }

    @Override
    public EnvVar buildFirstBuildArg() {
        return this.buildArgs.get(0).build();
    }

    @Override
    public EnvVar buildLastBuildArg() {
        return this.buildArgs.get(this.buildArgs.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.buildArgs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (this.buildArgs != null) {
            this._visitables.removeAll(this.buildArgs);
        }
        if (buildArgs != null) {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        } else {
            this.buildArgs = new ArrayList<EnvVarBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withBuildArgs(EnvVar ... buildArgs) {
        if (this.buildArgs != null) {
            this.buildArgs.clear();
        }
        if (buildArgs != null) {
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBuildArgs() {
        return this.buildArgs != null && !this.buildArgs.isEmpty();
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> addNewBuildArg() {
        return new BuildArgsNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> addNewBuildArgLike(EnvVar item) {
        return new BuildArgsNestedImpl(-1, item);
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> setNewBuildArgLike(int index, EnvVar item) {
        return new BuildArgsNestedImpl(index, item);
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> editBuildArg(int index) {
        if (this.buildArgs.size() <= index) {
            throw new RuntimeException("Can't edit buildArgs. Index exceeds size.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> editFirstBuildArg() {
        if (this.buildArgs.size() == 0) {
            throw new RuntimeException("Can't edit first buildArgs. The list is empty.");
        }
        return this.setNewBuildArgLike(0, this.buildBuildArg(0));
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> editLastBuildArg() {
        int index = this.buildArgs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last buildArgs. The list is empty.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    @Override
    public DockerBuildStrategyFluent.BuildArgsNested<A> editMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.buildArgs.size(); ++i) {
            if (!predicate.apply(this.buildArgs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching buildArgs. No match found.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    @Override
    public String getDockerfilePath() {
        return this.dockerfilePath;
    }

    @Override
    public A withDockerfilePath(String dockerfilePath) {
        this.dockerfilePath = dockerfilePath;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfilePath() {
        return this.dockerfilePath != null;
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return DockerBuildStrategyFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return DockerBuildStrategyFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public DockerBuildStrategyFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    public A withNewForcePull(String arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    public A withNewForcePull(boolean arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getImageOptimizationPolicy() {
        return this.imageOptimizationPolicy;
    }

    @Override
    public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
        this.imageOptimizationPolicy = imageOptimizationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImageOptimizationPolicy() {
        return this.imageOptimizationPolicy != null;
    }

    @Override
    public Boolean isNoCache() {
        return this.noCache;
    }

    @Override
    public A withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return (A)this;
    }

    @Override
    public Boolean hasNoCache() {
        return this.noCache != null;
    }

    @Override
    public A withNewNoCache(String arg1) {
        return this.withNoCache(new Boolean(arg1));
    }

    @Override
    public A withNewNoCache(boolean arg1) {
        return this.withNoCache(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl)o;
        if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) {
            return false;
        }
        if (this.dockerfilePath != null ? !this.dockerfilePath.equals(that.dockerfilePath) : that.dockerfilePath != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.imageOptimizationPolicy != null ? !this.imageOptimizationPolicy.equals(that.imageOptimizationPolicy) : that.imageOptimizationPolicy != null) {
            return false;
        }
        if (this.noCache != null ? !this.noCache.equals(that.noCache) : that.noCache != null) {
            return false;
        }
        return !(this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>>
    implements DockerBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>>
    implements DockerBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<DockerBuildStrategyFluent.EnvNested<N>>
    implements DockerBuildStrategyFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }

    public class BuildArgsNestedImpl<N>
    extends EnvVarFluentImpl<DockerBuildStrategyFluent.BuildArgsNested<N>>
    implements DockerBuildStrategyFluent.BuildArgsNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        BuildArgsNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        BuildArgsNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.setToBuildArgs(this.index, this.builder.build());
        }

        @Override
        public N endBuildArg() {
            return this.and();
        }
    }
}

