/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.LabelSelector;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorFluentImpl;
import io.ap4k.deps.openshift.api.model.UserRestriction;
import io.ap4k.deps.openshift.api.model.UserRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserRestrictionFluentImpl<A extends UserRestrictionFluent<A>>
extends BaseFluent<A>
implements UserRestrictionFluent<A> {
    private List<String> groups;
    private List<LabelSelectorBuilder> labels;
    private List<String> users;

    public UserRestrictionFluentImpl() {
    }

    public UserRestrictionFluentImpl(UserRestriction instance) {
        this.withGroups(instance.getGroups());
        this.withLabels(instance.getLabels());
        this.withUsers(instance.getUsers());
    }

    @Override
    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (this.groups != null) {
            this._visitables.removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.labels.add(index >= 0 ? index : this.labels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.labels.size()) {
            this.labels.add(builder);
        } else {
            this.labels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(LabelSelector ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLabels(Collection<LabelSelector> items) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(LabelSelector ... items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLabels(Collection<LabelSelector> items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LabelSelector> getLabels() {
        return UserRestrictionFluentImpl.build(this.labels);
    }

    @Override
    public List<LabelSelector> buildLabels() {
        return UserRestrictionFluentImpl.build(this.labels);
    }

    @Override
    public LabelSelector buildLabel(int index) {
        return this.labels.get(index).build();
    }

    @Override
    public LabelSelector buildFirstLabel() {
        return this.labels.get(0).build();
    }

    @Override
    public LabelSelector buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    @Override
    public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withLabels(List<LabelSelector> labels) {
        if (this.labels != null) {
            this._visitables.removeAll(this.labels);
        }
        if (labels != null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        } else {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withLabels(LabelSelector ... labels) {
        if (this.labels != null) {
            this.labels.clear();
        }
        if (labels != null) {
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> addNewLabel() {
        return new LabelsNestedImpl();
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> addNewLabelLike(LabelSelector item) {
        return new LabelsNestedImpl(-1, item);
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> setNewLabelLike(int index, LabelSelector item) {
        return new LabelsNestedImpl(index, item);
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editLabel(int index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.apply(this.labels.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public A addToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(int index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withUsers(List<String> users) {
        if (this.users != null) {
            this._visitables.removeAll(this.users);
        }
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserRestrictionFluentImpl that = (UserRestrictionFluentImpl)o;
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        return !(this.users != null ? !this.users.equals(that.users) : that.users != null);
    }

    public class LabelsNestedImpl<N>
    extends LabelSelectorFluentImpl<UserRestrictionFluent.LabelsNested<N>>
    implements UserRestrictionFluent.LabelsNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;
        private final int index;

        LabelsNestedImpl(int index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserRestrictionFluentImpl.this.setToLabels(this.index, this.builder.build());
        }

        @Override
        public N endLabel() {
            return this.and();
        }
    }
}

