/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.client;

import io.ap4k.deps.kubernetes.client.Client;
import io.ap4k.deps.kubernetes.client.ExtensionAdapter;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.openshift.client.DefaultOpenShiftClient;
import io.ap4k.deps.openshift.client.NamespacedOpenShiftClient;
import io.ap4k.deps.openshift.client.OpenShiftConfig;
import io.ap4k.deps.openshift.client.OpenShiftNotAvailableException;
import io.ap4k.deps.openshift.client.OpenshiftAdapterSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class NamespacedOpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<NamespacedOpenShiftClient> {
    @Override
    public Class<NamespacedOpenShiftClient> getExtensionType() {
        return NamespacedOpenShiftClient.class;
    }

    @Override
    public NamespacedOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include /oapi or the new /apis/*.openshift.io APIs.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }
}

