/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.client.dsl.internal;

import io.ap4k.deps.kubernetes.api.builder.TypedVisitor;
import io.ap4k.deps.kubernetes.api.model.ObjectReference;
import io.ap4k.deps.kubernetes.api.model.ObjectReferenceBuilder;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.dsl.Resource;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.openshift.api.model.DoneableRoleBinding;
import io.ap4k.deps.openshift.api.model.RoleBinding;
import io.ap4k.deps.openshift.api.model.RoleBindingBuilder;
import io.ap4k.deps.openshift.api.model.RoleBindingFluent;
import io.ap4k.deps.openshift.api.model.RoleBindingList;
import io.ap4k.deps.openshift.client.OpenShiftConfig;
import io.ap4k.deps.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class RoleBindingOperationsImpl
extends OpenShiftOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> {
    public RoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, (Boolean)true, null, null, (Boolean)false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public RoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, RoleBinding item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, OpenShiftOperation.withApiGroup(client, "authorization.openshift.io", apiVersion, config), "rolebindings", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public RoleBinding replace(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return super.replace(enriched);
    }

    @Override
    public RoleBinding patch(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return super.patch(enriched);
    }

    @Override
    protected RoleBinding handleCreate(RoleBinding resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return super.handleCreate(this.enrichRoleBinding(resource));
    }

    private RoleBinding enrichRoleBinding(RoleBinding binding) {
        RoleBindingBuilder builder = new RoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(RoleBindingBuilder builder) {
        builder.accept(new TypedVisitor<ObjectReferenceBuilder>(){

            @Override
            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals("ServiceAccount") && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(RoleBindingOperationsImpl.this.getNamespace());
                }
            }
        });
    }

    private void enrichFromUsersAndGroups(RoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("ServiceAccount")).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("User")).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("Group")).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(RoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(ref.getName());
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames("system:serviceaccount:" + namespace + ":" + ref.getName());
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(ref.getName());
                }
            }
        }
    }
}

