/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.servicecatalog.api.client.internal;

import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.servicecatalog.api.client.internal.ClusterServiceClassResource;
import io.ap4k.deps.servicecatalog.api.client.internal.ClusterServicePlanOperationImpl;
import io.ap4k.deps.servicecatalog.api.client.internal.ClusterServicePlanResource;
import io.ap4k.deps.servicecatalog.api.client.internal.ServiceInstanceOperationImpl;
import io.ap4k.deps.servicecatalog.api.client.util.ApiVersionUtil;
import io.ap4k.deps.servicecatalog.api.model.ClusterServiceClass;
import io.ap4k.deps.servicecatalog.api.model.ClusterServiceClassList;
import io.ap4k.deps.servicecatalog.api.model.ClusterServicePlan;
import io.ap4k.deps.servicecatalog.api.model.ClusterServicePlanList;
import io.ap4k.deps.servicecatalog.api.model.DoneableClusterServiceClass;
import io.ap4k.deps.servicecatalog.api.model.DoneableServiceInstance;
import io.ap4k.deps.servicecatalog.api.model.ServiceInstance;
import io.ap4k.deps.servicecatalog.api.model.ServiceInstanceFluent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClusterServiceClassOperationImpl
extends HasMetadataOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource>
implements ClusterServiceClassResource {
    public ClusterServiceClassOperationImpl(OkHttpClient client, Config config) {
        this(client, config, "servicecatalog.k8s.io", "v1beta1", null, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public ClusterServiceClassOperationImpl(OkHttpClient client, Config config, String apiGroup, String apiVersion, String namespace, String name, Boolean cascading, ClusterServiceClass item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, apiGroup, apiVersion, "clusterserviceclasses", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public ClusterServiceClassOperationImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ClusterServiceClass item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, ApiVersionUtil.apiGroup(item, apiVersion), ApiVersionUtil.apiVersion(item, apiVersion), "clusterserviceclasses", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ClusterServiceClassResource withName(String name) {
        return new ClusterServiceClassOperationImpl(this.client, this.config, this.apiGroup, this.apiVersion, this.namespace, name, this.isCascading(), (ClusterServiceClass)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return (ClusterServicePlanList)new ClusterServicePlanOperationImpl(this.client, this.config, this.apiGroup, this.apiVersion, this.namespace, null, this.isCascading(), null, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), new HashMap<String, String>()).withField("spec.clusterServiceClassRef.name", item != null ? item.getMetadata().getName() : null).list();
    }

    @Override
    public ClusterServicePlanResource usePlan(String externalName) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceClassRef.name", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List<ClusterServicePlan> list = ((ClusterServicePlanList)new ClusterServicePlanOperationImpl(this.client, this.config, this.apiGroup, this.apiVersion, this.namespace, null, this.isCascading(), null, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), fields).withFields(fields).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServicePlan with external name: " + externalName + " found for ClusterServiceBroker: " + item.getSpec().getClusterServiceBrokerName() + " and ClusterServiceClass: " + item.getSpec().getExternalName() + ".");
        }
        ClusterServicePlan p = list.get(0);
        return new ClusterServicePlanOperationImpl(this.client, this.config, this.apiGroup, this.apiVersion, this.namespace, p.getMetadata().getName(), this.isCascading(), null, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
    }

    @Override
    public ServiceInstance instantiate(String instanceName, String plan) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return ((DoneableServiceInstance)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((DoneableServiceInstance)((ServiceInstanceFluent.MetadataNested)((DoneableServiceInstance)new ServiceInstanceOperationImpl(this.client, this.config, this.apiGroup, this.apiVersion, this.namespace, null, this.isCascading(), null, null, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields()).createNew()).withNewMetadata().withName(instanceName)).endMetadata()).withNewSpec().withClusterServiceClassExternalName(item.getMetadata().getName())).withClusterServicePlanExternalName(plan)).endSpec()).done();
    }
}

