/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.zjsonpatch;

import io.ap4k.deps.zjsonpatch.internal.guava.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum Operation {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move");

    private static final Map<String, Operation> OPS;
    private String rfcName;

    private Operation(String rfcName) {
        this.rfcName = rfcName;
    }

    public static Operation fromRfcName(String rfcName) {
        Preconditions.checkNotNull(rfcName, "rfcName cannot be null", new Object[0]);
        return Preconditions.checkNotNull(OPS.get(rfcName.toLowerCase()), "unknown / unsupported operation %s", rfcName);
    }

    public String rfcName() {
        return this.rfcName;
    }

    private static <K, V> Map<K, V> immutableMap(Object ... keyValPair) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (keyValPair.length % 2 != 0) {
            throw new IllegalArgumentException("Keys and values must be pairs.");
        }
        for (int i = 0; i < keyValPair.length; i += 2) {
            map.put(keyValPair[i], keyValPair[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }

    static {
        OPS = Operation.immutableMap(new Object[]{Operation.ADD.rfcName, ADD, Operation.REMOVE.rfcName, REMOVE, Operation.REPLACE.rfcName, REPLACE, Operation.MOVE.rfcName, MOVE});
    }
}

