/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.deps.jackson.annotation.JsonIgnore;
import io.ap4k.kubernetes.config.ConfigKey;
import io.ap4k.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Configuration {
    private Project project;
    private Map<ConfigKey, Object> attributes;

    public Configuration() {
        this(null, null);
    }

    public Configuration(Project project, Map<ConfigKey, Object> attributes) {
        this.project = project;
        this.attributes = attributes != null ? attributes : new HashMap();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @JsonIgnore
    public Map<ConfigKey, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<ConfigKey, Object> attributes) {
        this.attributes = attributes;
    }

    public <T> T getAttribute(ConfigKey<T> key) {
        return (T)this.attributes.get(key);
    }

    public <T> T getAttributeOrDefault(ConfigKey<T> key) {
        if (this.attributes.containsKey(key)) {
            return (T)this.attributes.get(key);
        }
        if (key.getDefaultValue() != null) {
            return key.getDefaultValue();
        }
        throw new IllegalStateException("No attribute named: " + key.getName() + " was found and no default value has been configured.");
    }

    public <T> T put(ConfigKey<T> key, T value) {
        return (T)this.attributes.put(key, value);
    }

    public <T> boolean hasAttribute(ConfigKey<T> key) {
        return this.attributes.containsKey(key);
    }

    public Set<Map.Entry<ConfigKey, Object>> entrySet() {
        return this.attributes.entrySet();
    }
}

