/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.EditableSecretVolume;
import io.ap4k.kubernetes.config.SecretVolume;
import io.ap4k.kubernetes.config.SecretVolumeFluent;
import io.ap4k.kubernetes.config.SecretVolumeFluentImpl;

public class SecretVolumeBuilder
extends SecretVolumeFluentImpl<SecretVolumeBuilder>
implements VisitableBuilder<SecretVolume, SecretVolumeBuilder> {
    SecretVolumeFluent<?> fluent;
    Boolean validationEnabled;

    public SecretVolumeBuilder() {
        this(true);
    }

    public SecretVolumeBuilder(Boolean validationEnabled) {
        this(new SecretVolume(), validationEnabled);
    }

    public SecretVolumeBuilder(SecretVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretVolumeBuilder(SecretVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretVolume(), validationEnabled);
    }

    public SecretVolumeBuilder(SecretVolumeFluent<?> fluent, SecretVolume instance) {
        this(fluent, instance, true);
    }

    public SecretVolumeBuilder(SecretVolumeFluent<?> fluent, SecretVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withVolumeName(instance.getVolumeName());
        fluent.withSecretName(instance.getSecretName());
        fluent.withDefaultMode(instance.getDefaultMode());
        fluent.withOptional(instance.isOptional());
        this.validationEnabled = validationEnabled;
    }

    public SecretVolumeBuilder(SecretVolume instance) {
        this(instance, (Boolean)true);
    }

    public SecretVolumeBuilder(SecretVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withVolumeName(instance.getVolumeName());
        this.withSecretName(instance.getSecretName());
        this.withDefaultMode(instance.getDefaultMode());
        this.withOptional(instance.isOptional());
        this.validationEnabled = validationEnabled;
    }

    public EditableSecretVolume build() {
        EditableSecretVolume buildable = new EditableSecretVolume(this.fluent.getVolumeName(), this.fluent.getSecretName(), this.fluent.getDefaultMode(), this.fluent.isOptional());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretVolumeBuilder that = (SecretVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

