/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.Annotation;
import io.ap4k.kubernetes.decorator.ApplicationResourceDecorator;
import java.util.Objects;

@Description(value="A decorator that adds an annotation to all resources.")
public class AddAnnotationDecorator
extends ApplicationResourceDecorator<ObjectMetaBuilder> {
    private final Annotation annotation;

    public AddAnnotationDecorator(Annotation annotation) {
        this(ANY, annotation);
    }

    public AddAnnotationDecorator(String name, Annotation annotation) {
        super(name);
        this.annotation = annotation;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder) {
        builder.addToAnnotations(this.annotation.getKey(), this.annotation.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddAnnotationDecorator that = (AddAnnotationDecorator)o;
        return Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }
}

