/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.generator;

import io.ap4k.Generator;
import io.ap4k.SessionListener;
import io.ap4k.WithProject;
import io.ap4k.config.ConfigurationSupplier;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesResourceList;
import io.ap4k.deps.kubernetes.client.DefaultKubernetesClient;
import io.ap4k.kubernetes.adapter.KubernetesConfigAdapter;
import io.ap4k.kubernetes.annotation.KubernetesApplication;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.KubernetesConfigBuilder;
import io.ap4k.kubernetes.configurator.ApplyAutoBuild;
import io.ap4k.kubernetes.handler.KubernetesHandler;
import io.ap4k.project.ApplyProjectInfo;
import java.util.Map;
import javax.lang.model.element.Element;

public interface KubernetesApplicationGenerator
extends Generator,
SessionListener,
WithProject {
    public static final String KUBERNETES = "kubernetes";

    default public void add(Map map) {
        this.add((ConfigurationSupplier<KubernetesConfig>)new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(this.propertiesMap(map, KubernetesApplication.class)).accept((Visitor)new ApplyAutoBuild())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(Element element) {
        KubernetesApplication application = element.getAnnotation(KubernetesApplication.class);
        this.add((ConfigurationSupplier<KubernetesConfig>)new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(application).accept((Visitor)new ApplyAutoBuild())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(ConfigurationSupplier<KubernetesConfig> config) {
        session.configurators().add(config);
        session.handlers().add(new KubernetesHandler(session.resources()));
        session.addListener((SessionListener)this);
    }

    default public void onClosed() {
        Boolean autoDeployEnabled = session.configurators().get(KubernetesConfig.class).map(c -> c.isAutoDeployEnabled()).orElse(false);
        if (autoDeployEnabled.booleanValue()) {
            KubernetesList generated = session.getGeneratedResources().getOrDefault(KUBERNETES, new KubernetesList());
            DefaultKubernetesClient client = new DefaultKubernetesClient();
            client.resourceList((KubernetesResourceList)generated).createOrReplace();
        }
    }
}

