/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.handler;

import io.ap4k.AbstractKubernetesHandler;
import io.ap4k.Resources;
import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.deps.kubernetes.api.model.EnvVarFluent;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.LabelSelector;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.ap4k.deps.kubernetes.api.model.PodSpec;
import io.ap4k.deps.kubernetes.api.model.PodSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodSpecFluent;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpec;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.ap4k.deps.kubernetes.api.model.apps.Deployment;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentBuilder;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentFluent;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.EditableKubernetesConfig;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.decorator.AddIngressDecorator;
import io.ap4k.kubernetes.decorator.ApplyImageDecorator;
import io.ap4k.kubernetes.decorator.ApplyLabelSelectorDecorator;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Labels;
import java.util.Optional;

public class KubernetesHandler
extends AbstractKubernetesHandler<KubernetesConfig> {
    private static final String KUBERNETES = "kubernetes";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";

    public KubernetesHandler() {
        this(new Resources());
    }

    public KubernetesHandler(Resources resources) {
        super(resources);
    }

    public int order() {
        return 200;
    }

    public void handle(KubernetesConfig config) {
        this.setApplicationInfo(config);
        Optional<Deployment> existingDeployment = this.resources.groups().getOrDefault(KUBERNETES, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Deployment).map(i -> (Deployment)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeployment.isPresent()) {
            this.resources.add(KUBERNETES, (HasMetadata)this.createDeployment(config));
        }
        this.addDecorators(KUBERNETES, config);
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, config);
        this.resources.decorate(group, (Decorator)new AddIngressDecorator(config, this.resources.getLabels()));
        this.resources.decorate(group, (Decorator)new ApplyLabelSelectorDecorator(this.createSelector()));
        this.resources.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), config.getGroup() + "/" + config.getName() + ":" + config.getVersion()));
    }

    public Deployment createDeployment(KubernetesConfig config) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(config.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withNewReplicas(1)).withTemplate(KubernetesHandler.createPodTemplateSpec(config))).withSelector(this.createSelector())).endSpec()).build();
    }

    public LabelSelector createSelector() {
        return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(this.resources.getLabels())).build();
    }

    public static PodTemplateSpec createPodTemplateSpec(KubernetesConfig config) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(KubernetesHandler.createPodSpec(config))).withNewMetadata().withLabels(Labels.createLabels((KubernetesConfig)config))).endMetadata()).build();
    }

    public static PodSpec createPodSpec(KubernetesConfig config) {
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage(config.getGroup() + "/" + config.getName() + ":" + config.getVersion())).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }
}

