/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.adapter;

import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.ContainerBuilder;
import io.ap4k.kubernetes.config.Container;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.Mount;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.decorator.AddEnvVarDecorator;
import io.ap4k.kubernetes.decorator.AddLivenessProbeDecorator;
import io.ap4k.kubernetes.decorator.AddMountDecorator;
import io.ap4k.kubernetes.decorator.AddPortDecorator;
import io.ap4k.kubernetes.decorator.AddReadinessProbeDecorator;
import io.ap4k.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.ap4k.utils.Images;
import io.ap4k.utils.Strings;

public class ContainerAdapter {
    public static io.ap4k.deps.kubernetes.api.model.Container adapt(Container container) {
        String name = container.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = Images.getName((String)container.getImage());
        }
        ContainerBuilder builder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(name)).withImage(container.getImage())).withCommand(container.getCommand())).withArgs(container.getArguments());
        for (Env env : container.getEnvVars()) {
            builder.accept((Visitor)new AddEnvVarDecorator(env));
        }
        for (Port port : container.getPorts()) {
            builder.accept((Visitor)new AddPortDecorator(port));
        }
        for (Mount mount : container.getMounts()) {
            builder.accept((Visitor)new AddMountDecorator(mount));
        }
        builder.accept((Visitor)new ApplyImagePullPolicyDecorator(container.getImagePullPolicy()));
        builder.accept((Visitor)new AddLivenessProbeDecorator(name, container.getLivenessProbe()));
        builder.accept((Visitor)new AddReadinessProbeDecorator(name, container.getReadinessProbe()));
        return builder.build();
    }
}

