/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.adapter;

import io.ap4k.kubernetes.annotation.ImagePullPolicy;
import io.ap4k.kubernetes.annotation.KubernetesApplication;
import io.ap4k.kubernetes.annotation.Protocol;
import io.ap4k.kubernetes.config.Annotation;
import io.ap4k.kubernetes.config.AwsElasticBlockStoreVolume;
import io.ap4k.kubernetes.config.AzureDiskVolume;
import io.ap4k.kubernetes.config.AzureFileVolume;
import io.ap4k.kubernetes.config.ConfigMapVolume;
import io.ap4k.kubernetes.config.Container;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.GitRepoVolume;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.KubernetesConfigBuilder;
import io.ap4k.kubernetes.config.Label;
import io.ap4k.kubernetes.config.Mount;
import io.ap4k.kubernetes.config.PersistentVolumeClaimVolume;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.config.SecretVolume;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesConfigAdapter {
    public static KubernetesConfig adapt(KubernetesApplication instance) {
        return KubernetesConfigAdapter.newBuilder(instance).build();
    }

    public static KubernetesConfigBuilder newBuilder(KubernetesApplication instance) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, instance.group(), instance.name(), instance.version(), Arrays.asList(instance.initContainers()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), j.containerPort(), j.hostPort(), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().initialDelaySeconds(), i.livenessProbe().periodSeconds(), i.livenessProbe().timeoutSeconds()), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().initialDelaySeconds(), i.readinessProbe().periodSeconds(), i.readinessProbe().timeoutSeconds()))).collect(Collectors.toList()).toArray(new Container[0]), Arrays.asList(instance.labels()).stream().map(i -> new Label(i.key(), i.value())).collect(Collectors.toList()).toArray(new Label[0]), Arrays.asList(instance.annotations()).stream().map(i -> new Annotation(i.key(), i.value())).collect(Collectors.toList()).toArray(new Annotation[0]), Arrays.asList(instance.envVars()).stream().map(i -> new Env(i.name(), i.value(), i.secret(), i.configmap(), i.field())).collect(Collectors.toList()).toArray(new Env[0]), instance.workingDir(), instance.command(), instance.arguments(), instance.replicas(), instance.serviceAccount(), instance.host(), Arrays.asList(instance.ports()).stream().map(i -> new Port(i.name(), i.containerPort(), i.hostPort(), i.path(), i.protocol())).collect(Collectors.toList()).toArray(new Port[0]), instance.serviceType(), Arrays.asList(instance.pvcVolumes()).stream().map(i -> new PersistentVolumeClaimVolume(i.volumeName(), i.claimName(), i.readOnly())).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(instance.secretVolumes()).stream().map(i -> new SecretVolume(i.volumeName(), i.secretName(), i.defaultMode(), i.optional())).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(instance.configMapVolumes()).stream().map(i -> new ConfigMapVolume(i.volumeName(), i.configMapName(), i.defaultMode(), i.optional())).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(instance.gitRepoVolumes()).stream().map(i -> new GitRepoVolume(i.volumeName(), i.repository(), i.directory(), i.revision())).collect(Collectors.toList()).toArray(new GitRepoVolume[0]), Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i -> new AwsElasticBlockStoreVolume(i.volumeName(), i.volumeId(), i.partition(), i.fsType(), i.readOnly())).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(instance.azureDiskVolumes()).stream().map(i -> new AzureDiskVolume(i.volumeName(), i.diskName(), i.diskURI(), i.kind(), i.cachingMode(), i.fsType(), i.readOnly())).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(instance.azureFileVolumes()).stream().map(i -> new AzureFileVolume(i.volumeName(), i.shareName(), i.secretName(), i.readOnly())).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(instance.mounts()).stream().map(i -> new Mount(i.name(), i.path(), i.subPath(), i.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), instance.imagePullPolicy(), new Probe(instance.livenessProbe().httpActionPath(), instance.livenessProbe().execAction(), instance.livenessProbe().tcpSocketAction(), instance.livenessProbe().initialDelaySeconds(), instance.livenessProbe().periodSeconds(), instance.livenessProbe().timeoutSeconds()), new Probe(instance.readinessProbe().httpActionPath(), instance.readinessProbe().execAction(), instance.readinessProbe().tcpSocketAction(), instance.readinessProbe().initialDelaySeconds(), instance.readinessProbe().periodSeconds(), instance.readinessProbe().timeoutSeconds()), Arrays.asList(instance.sidecars()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), j.containerPort(), j.hostPort(), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().initialDelaySeconds(), i.livenessProbe().periodSeconds(), i.livenessProbe().timeoutSeconds()), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().initialDelaySeconds(), i.readinessProbe().periodSeconds(), i.readinessProbe().timeoutSeconds()))).collect(Collectors.toList()).toArray(new Container[0]), instance.expose(), instance.autoDeployEnabled(), instance.dockerFile(), instance.registry(), instance.autoPushEnabled(), instance.autoBuildEnabled()));
    }

    public static KubernetesConfig adapt(Map map) {
        return new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("group", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? i.getOrDefault("command", new String[0]) : new String[]{}, i instanceof Map ? i.getOrDefault("arguments", new String[0]) : new String[]{}, (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", j instanceof Map ? j.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), i instanceof Map ? i.getOrDefault("imagePullPolicy", ImagePullPolicy.IfNotPresent) : ImagePullPolicy.IfNotPresent, new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)))).toArray(Container[]::new), (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null)).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null)).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? map.getOrDefault("command", new String[0]) : new String[]{}, map instanceof Map ? map.getOrDefault("arguments", new String[0]) : new String[]{}, map instanceof Map ? map.getOrDefault("replicas", 0) : Integer.valueOf(0), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("containerPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", i instanceof Map ? i.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), map instanceof Map ? map.getOrDefault("serviceType", null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("claimName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 600) : Integer.valueOf(600), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("configMapName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 600) : Integer.valueOf(600), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("repository", null) : null, i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("volumeId", null) : null, i instanceof Map ? i.getOrDefault("partition", null) : null, i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("diskName", null) : null, i instanceof Map ? i.getOrDefault("diskURI", null) : null, i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("shareName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("path", null) : null, i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? map.getOrDefault("imagePullPolicy", null) : null, new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? i.getOrDefault("command", new String[0]) : new String[]{}, i instanceof Map ? i.getOrDefault("arguments", new String[0]) : new String[]{}, (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", j instanceof Map ? j.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), i instanceof Map ? i.getOrDefault("imagePullPolicy", ImagePullPolicy.IfNotPresent) : ImagePullPolicy.IfNotPresent, new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("autoDeployEnabled", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("dockerFile", "Dockerfile") : "Dockerfile", map instanceof Map ? map.getOrDefault("registry", "") : "", map instanceof Map ? map.getOrDefault("autoPushEnabled", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("autoBuildEnabled", false) : Boolean.valueOf(false));
    }

    public static KubernetesConfigBuilder newBuilder(Map map) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("group", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? i.getOrDefault("command", new String[0]) : new String[]{}, i instanceof Map ? i.getOrDefault("arguments", new String[0]) : new String[]{}, (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", j instanceof Map ? j.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), i instanceof Map ? i.getOrDefault("imagePullPolicy", ImagePullPolicy.IfNotPresent) : ImagePullPolicy.IfNotPresent, new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)))).toArray(Container[]::new), (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null)).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null)).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? map.getOrDefault("command", new String[0]) : new String[]{}, map instanceof Map ? map.getOrDefault("arguments", new String[0]) : new String[]{}, map instanceof Map ? map.getOrDefault("replicas", 0) : Integer.valueOf(0), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("containerPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", i instanceof Map ? i.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), map instanceof Map ? map.getOrDefault("serviceType", null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("claimName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 600) : Integer.valueOf(600), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("configMapName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 600) : Integer.valueOf(600), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("repository", null) : null, i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("volumeId", null) : null, i instanceof Map ? i.getOrDefault("partition", null) : null, i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("diskName", null) : null, i instanceof Map ? i.getOrDefault("diskURI", null) : null, i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("shareName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("path", null) : null, i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? map.getOrDefault("imagePullPolicy", null) : null, new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? i.getOrDefault("command", new String[0]) : new String[]{}, i instanceof Map ? i.getOrDefault("arguments", new String[0]) : new String[]{}, (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", j instanceof Map ? j.getOrDefault("protocol", Protocol.TCP) : Protocol.TCP)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), i instanceof Map ? i.getOrDefault("imagePullPolicy", ImagePullPolicy.IfNotPresent) : ImagePullPolicy.IfNotPresent, new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("autoDeployEnabled", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("dockerFile", "Dockerfile") : "Dockerfile", map instanceof Map ? map.getOrDefault("registry", "") : "", map instanceof Map ? map.getOrDefault("autoPushEnabled", false) : Boolean.valueOf(false), map instanceof Map ? map.getOrDefault("autoBuildEnabled", false) : Boolean.valueOf(false)));
    }
}

