/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.ap4k.deps.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.ap4k.deps.kubernetes.api.model.extensions.IngressFluent;
import io.ap4k.deps.kubernetes.api.model.extensions.IngressRuleFluent;
import io.ap4k.deps.kubernetes.api.model.extensions.IngressSpecFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.BaseConfig;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Ports;
import java.util.Map;
import java.util.Optional;

@Description(value="Add an ingress to the list.")
public class AddIngressDecorator
extends Decorator<KubernetesListBuilder> {
    private final KubernetesConfig config;
    private final Map<String, String> allLabels;

    public AddIngressDecorator(KubernetesConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((BaseConfig)this.config);
        if (!p.isPresent() || !this.config.isExpose()) {
            return;
        }
        Port port = (Port)p.get();
        ((BaseKubernetesListFluent.IngressItemsNested)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((BaseKubernetesListFluent.IngressItemsNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)list.addNewIngressItem().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().addNewRule().withHost(this.config.getHost())).withNewHttp().addNewPath().withPath(port.getPath())).withNewBackend().withServiceName(this.config.getName())).withNewServicePort(Integer.valueOf(port.getContainerPort()))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).endIngressItem();
    }
}

