/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.ap4k.deps.kubernetes.api.model.IntOrString;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.ServiceFluent;
import io.ap4k.deps.kubernetes.api.model.ServicePort;
import io.ap4k.deps.kubernetes.api.model.ServicePortBuilder;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.BaseConfig;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Labels;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Description(value="Add a service to the list.")
public class AddServiceDecorator
extends Decorator<KubernetesListBuilder> {
    private final BaseConfig config;
    private final Map<String, String> allLabels;

    public AddServiceDecorator(BaseConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        ((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)list.addNewServiceItem().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().withType(this.config.getServiceType().name())).withSelector(Labels.createLabels((BaseConfig)this.config))).withPorts(Arrays.asList(this.config.getPorts()).stream().map(this::toServicePort).collect(Collectors.toList()))).endSpec()).endServiceItem();
    }

    private ServicePort toServicePort(Port port) {
        return ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(port.getName())).withPort(Integer.valueOf(port.getContainerPort()))).withTargetPort(new IntOrString(Integer.valueOf(port.getHostPort() > 0 ? port.getHostPort() : port.getContainerPort())))).build();
    }
}

