/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.Resources;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentBuilder;
import io.ap4k.kubernetes.decorator.ApplyImageDecorator;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Images;

public class ApplyRegistryToImageDecorator
extends Decorator<DeploymentBuilder> {
    private final String registry;
    private final Resources resources;

    public ApplyRegistryToImageDecorator(Resources resources, String registry) {
        this.registry = registry;
        this.resources = resources;
    }

    public void visit(DeploymentBuilder deployment) {
        final String name = this.resources.getName();
        if (name.equals(deployment.getMetadata().getName())) {
            deployment.accept((Visitor)new Decorator<ContainerFluent>(){

                public void visit(ContainerFluent container) {
                    if (container.getName().equals(name)) {
                        String image = Images.getImage((String)ApplyRegistryToImageDecorator.this.registry, (String)ApplyRegistryToImageDecorator.this.resources.getGroup(), (String)ApplyRegistryToImageDecorator.this.resources.getName(), (String)ApplyRegistryToImageDecorator.this.resources.getVersion());
                        container.withImage(image);
                    }
                }
            });
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ApplyImageDecorator.class};
    }
}

