/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.ApplicationContainerDecorator;
import io.ap4k.utils.Strings;

@Description(value="A decorator that applies the working directory to the application container.")
public class ApplyWorkingDirDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private final String workingDir;

    public ApplyWorkingDirDecorator(String containerName, String workingDir) {
        super(null, containerName);
        this.workingDir = workingDir;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        if (this.isApplicable(container) && Strings.isNotNullOrEmpty((String)this.workingDir)) {
            container.withWorkingDir(this.workingDir);
        }
    }
}

