/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.generator;

import io.ap4k.Generator;
import io.ap4k.Resources;
import io.ap4k.SessionListener;
import io.ap4k.WithProject;
import io.ap4k.config.ConfigurationSupplier;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesResourceList;
import io.ap4k.deps.kubernetes.client.DefaultKubernetesClient;
import io.ap4k.hook.OrderedHook;
import io.ap4k.hook.ProjectHook;
import io.ap4k.kubernetes.adapter.KubernetesConfigAdapter;
import io.ap4k.kubernetes.annotation.KubernetesApplication;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.KubernetesConfigBuilder;
import io.ap4k.kubernetes.configurator.ApplyAutoBuild;
import io.ap4k.kubernetes.configurator.ApplyDockerBuildHook;
import io.ap4k.kubernetes.handler.KubernetesHandler;
import io.ap4k.kubernetes.hook.DockerBuildHook;
import io.ap4k.kubernetes.hook.DockerPushHook;
import io.ap4k.kubernetes.hook.ScaleDeploymentHook;
import io.ap4k.project.ApplyProjectInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;

public interface KubernetesApplicationGenerator
extends Generator,
SessionListener,
WithProject {
    public static final String KUBERNETES = "kubernetes";

    default public void add(Map map) {
        this.add((ConfigurationSupplier<KubernetesConfig>)new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(this.propertiesMap(map, KubernetesApplication.class)).accept((Visitor)new ApplyAutoBuild())).accept((Visitor)new ApplyProjectInfo(this.getProject()))).accept((Visitor)new ApplyDockerBuildHook())));
    }

    default public void add(Element element) {
        KubernetesApplication application = element.getAnnotation(KubernetesApplication.class);
        this.add((ConfigurationSupplier<KubernetesConfig>)new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(application).accept((Visitor)new ApplyAutoBuild())).accept((Visitor)new ApplyProjectInfo(this.getProject()))).accept((Visitor)new ApplyDockerBuildHook())));
    }

    default public void add(ConfigurationSupplier<KubernetesConfig> config) {
        session.configurators().add(config);
        session.handlers().add(new KubernetesHandler(session.resources()));
        session.addListener((SessionListener)this);
    }

    default public void onClosed() {
        Optional config = session.configurators().get(KubernetesConfig.class);
        if (!config.isPresent()) {
            return;
        }
        KubernetesConfig kubernetesConfig = (KubernetesConfig)config.get();
        Resources resources = session.resources();
        if (kubernetesConfig.isAutoPushEnabled()) {
            ArrayList<ProjectHook> hooks = new ArrayList<ProjectHook>();
            if (kubernetesConfig.isAutoDeployEnabled()) {
                KubernetesList generated = session.getGeneratedResources().getOrDefault(KUBERNETES, new KubernetesList());
                try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
                    client.resourceList((KubernetesResourceList)generated).createOrReplace();
                }
                hooks.add(new ScaleDeploymentHook(this.getProject(), session.resources().getName(), 0));
            }
            hooks.add(new DockerBuildHook(this.getProject(), (KubernetesConfig)config.get()));
            hooks.add(new DockerPushHook(this.getProject(), (KubernetesConfig)config.get()));
            if (kubernetesConfig.isAutoDeployEnabled()) {
                hooks.add(new ScaleDeploymentHook(this.getProject(), session.resources().getName(), 1));
            }
            OrderedHook hook = OrderedHook.create((ProjectHook[])hooks.toArray(new ProjectHook[hooks.size()]));
            hook.register();
        } else if (kubernetesConfig.isAutoBuildEnabled()) {
            DockerBuildHook hook = new DockerBuildHook(this.getProject(), (KubernetesConfig)config.get());
            hook.register();
        }
    }
}

