/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.codegen.maven;

import io.apicurio.codegen.maven.ProjectSettings;
import io.apicurio.hub.api.codegen.JaxRsProjectSettings;
import io.apicurio.hub.api.codegen.OpenApi2JaxRs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class GenerateCodeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(required=true)
    ProjectSettings projectSettings;
    @Parameter(required=true)
    File inputSpec;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jaxrs")
    File outputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating JAX-RS interfaces and beans from: " + this.inputSpec));
        if (this.inputSpec == null || !this.inputSpec.isFile()) {
            throw new MojoFailureException("Input spec not found.");
        }
        if (this.outputDir.isFile()) {
            throw new MojoFailureException("Output directory is unexpectedly a file (should be a directory or non-existent).");
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.getLog().info((CharSequence)("Generating code into: " + this.outputDir.getAbsolutePath()));
        this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        File zipFile = new File(this.outputDir, "generated-code.zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            OpenApi2JaxRs generator = new OpenApi2JaxRs();
            generator.setSettings((JaxRsProjectSettings)this.projectSettings);
            generator.setUpdateOnly(true);
            generator.setOpenApiDocument(this.inputSpec.toURI().toURL());
            this.getLog().info((CharSequence)"Generating code...");
            generator.generate((OutputStream)fos);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException((Throwable)e);
        }
        this.getLog().info((CharSequence)"Code generated, unpacking the output ZIP.");
        try {
            this.unzip(zipFile, this.outputDir);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException((Throwable)e);
        }
        finally {
            zipFile.delete();
        }
        this.getLog().info((CharSequence)"Code successfully generated.");
    }

    private void unzip(File fromZipFile, File toOutputDir) throws ZipException, IOException {
        try (ZipFile zipFile = new ZipFile(fromZipFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(toOutputDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(entryDestination);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }
}

