/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.openapi.server.generator.deployment.codegen;

import io.apicurio.hub.api.codegen.JaxRsProjectSettings;
import io.apicurio.hub.api.codegen.OpenApi2JaxRs;
import io.apicurio.openapi.server.generator.deployment.CodegenConfig;
import io.apicurio.openapi.server.generator.deployment.codegen.ApicurioOpenApiServerCodegen;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApicurioCodegenWrapper {
    private static final Logger log = LoggerFactory.getLogger(ApicurioOpenApiServerCodegen.class);
    private static final String DEFAULT_PACKAGE = "io.apicurio.api";
    private final Config config;
    private final File outdir;
    private final JaxRsProjectSettings projectSettings;

    public ApicurioCodegenWrapper(Config config, File outdir) {
        this(config, outdir, ApicurioCodegenWrapper.defaultProjectSettings());
    }

    public ApicurioCodegenWrapper(Config config, File outdir, JaxRsProjectSettings projectSettings) {
        this.config = config;
        this.outdir = outdir;
        this.projectSettings = projectSettings;
        this.projectSettings.setJavaPackage(this.getBasePackage(config));
    }

    public void generate(Path openApiResource) throws CodeGenException {
        File openApiFile = openApiResource.toFile();
        log.info("Generating JAX-RS interfaces and beans from: " + openApiResource);
        if (this.outdir.isFile()) {
            throw new CodeGenException("Output directory is unexpectedly a file (should be a directory or non-existent).");
        }
        if (!this.outdir.exists()) {
            this.outdir.mkdirs();
        }
        File zipFile = new File(this.outdir, "generated-code.zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            OpenApi2JaxRs generator = new OpenApi2JaxRs();
            generator.setSettings(this.projectSettings);
            generator.setUpdateOnly(true);
            generator.setOpenApiDocument((InputStream)new FileInputStream(openApiFile));
            log.info("Generating code...");
            generator.generate((OutputStream)fos);
        }
        catch (Exception e) {
            log.error("Error generating code from openapi spec", (Throwable)e);
            throw new CodeGenException((Throwable)e);
        }
        log.info("Code generated, unpacking the output ZIP.");
        try {
            this.unzip(zipFile, this.outdir);
        }
        catch (IOException e) {
            log.error("Error generating code from openapi spec", (Throwable)e);
            throw new CodeGenException((Throwable)e);
        }
        finally {
            zipFile.delete();
        }
        log.info("Code successfully generated.");
    }

    private void unzip(File fromZipFile, File toOutputDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(fromZipFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(toOutputDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(entryDestination);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private String getBasePackage(Config config) {
        return config.getOptionalValue(CodegenConfig.getBasePackagePropertyName(), String.class).orElse(DEFAULT_PACKAGE);
    }

    private static JaxRsProjectSettings defaultProjectSettings() {
        JaxRsProjectSettings projectSettings = new JaxRsProjectSettings();
        projectSettings.setJavaPackage(DEFAULT_PACKAGE);
        projectSettings.setReactive(false);
        projectSettings.setCodeOnly(true);
        projectSettings.setCliGenCI(false);
        projectSettings.setMavenFileStructure(false);
        projectSettings.setIncludeSpec(false);
        projectSettings.setCliGenCI(false);
        return projectSettings;
    }
}

