/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.openapi.server.generator.deployment.codegen;

import io.apicurio.openapi.server.generator.deployment.CodegenConfig;
import io.apicurio.openapi.server.generator.deployment.codegen.ApicurioCodegenWrapper;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;

public class ApicurioOpenApiServerCodegen
implements CodeGenProvider {
    public String providerId() {
        return "jaxrs";
    }

    public String inputExtension() {
        return "json";
    }

    public String inputDirectory() {
        return "resources";
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return sourceDir != null && config.getOptionalValue(CodegenConfig.getSpecPropertyName(), String.class).isPresent();
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Path openApiDir = context.inputDir();
        Path outDir = context.outDir();
        ApicurioCodegenWrapper apicurioCodegenWrapper = new ApicurioCodegenWrapper(context.config(), outDir.toFile());
        if (Files.isDirectory(openApiDir, new LinkOption[0])) {
            try (Stream<Path> openApiFilesPaths = Files.walk(openApiDir, new FileVisitOption[0]);){
                openApiFilesPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(s -> s.endsWith(this.inputExtension())).map(x$0 -> Path.of(x$0, new String[0])).forEach(openApiResource -> {
                    try {
                        apicurioCodegenWrapper.generate((Path)openApiResource);
                    }
                    catch (CodeGenException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                throw new CodeGenException("Failed to generate java files from OpenApi file in " + openApiDir.toAbsolutePath(), (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

