/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.util;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import org.apache.commons.lang.StringUtils;

public final class CodegenUtil {
    public static final String schemaToPackageName(OasSchema schema, String defaultPackage) {
        String packageName;
        Extension extension;
        String pname = defaultPackage;
        if (schema != null && (extension = schema.getExtension("x-codegen-package")) != null && extension.value != null && !(packageName = String.valueOf(extension.value)).trim().isEmpty()) {
            pname = packageName;
        }
        return pname;
    }

    public static final String schemaRefToFQCN(Document document, String schemaRef, String defaultPackage) {
        Oas20SchemaDefinition definition;
        Object cname = "GeneratedClass_" + System.currentTimeMillis();
        String pname = defaultPackage;
        if (schemaRef.startsWith("#/definitions/")) {
            cname = schemaRef.substring(14);
            Oas20Document doc20 = (Oas20Document)document;
            if (doc20.definitions != null) {
                definition = doc20.definitions.getDefinition((String)cname);
                pname = CodegenUtil.schemaToPackageName((OasSchema)definition, pname);
            }
        }
        if (schemaRef.startsWith("#/components/schemas/")) {
            cname = schemaRef.substring(21);
            Oas30Document doc30 = (Oas30Document)document;
            if (doc30.components != null) {
                definition = doc30.components.getSchemaDefinition((String)cname);
                pname = CodegenUtil.schemaToPackageName((OasSchema)definition, pname);
            }
        }
        return pname + "." + StringUtils.capitalize((String)cname);
    }
}

