/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.auth.authn;

import io.apicurio.common.apps.util.Pair;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;

public class CredentialsHelper {
    private static final String BASIC = "basic";
    private static final String BASIC_PREFIX = "basic ";
    private static final String LOWERCASE_BASIC_PREFIX = "basic ".toLowerCase(Locale.ENGLISH);
    private static final int PREFIX_LENGTH = "basic ".length();
    private static final Charset charset = StandardCharsets.UTF_8;

    public static Pair<String, String> extractCredentialsFromContext(RoutingContext context) {
        List authHeaders = context.request().headers().getAll((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                String COLON;
                if (!current.toLowerCase(Locale.ENGLISH).startsWith(LOWERCASE_BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                byte[] decode = Base64.getDecoder().decode(base64Challenge);
                String plainChallenge = new String(decode, charset);
                int colonPos = plainChallenge.indexOf(COLON = ":");
                if (colonPos <= -1) continue;
                String userName = plainChallenge.substring(0, colonPos);
                String password = plainChallenge.substring(colonPos + 1);
                return new Pair((Object)userName, (Object)password);
            }
        }
        return null;
    }
}

