/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config;

import java.util.Objects;

public class DynamicConfigPropertyDef {
    private String name;
    private Class type;
    private String defaultValue;
    private String label;
    private String description;
    private String[] requires;

    public DynamicConfigPropertyDef() {
    }

    public DynamicConfigPropertyDef(String name, Class type, String defaultValue) {
        this.setName(name);
        this.setType(type);
        this.setDefaultValue(defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public boolean isValidValue(String value) {
        try {
            if (this.getType() == Long.class) {
                Long.parseLong(value);
            }
            if (this.getType() == Integer.class) {
                Integer.parseInt(value);
            }
            if (this.getType() == Boolean.class && !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                throw new Exception("Invalid boolean value: " + value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicConfigPropertyDef other = (DynamicConfigPropertyDef)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return "DynamicConfigPropertyDef [name=" + this.name + ", type=" + this.type + "]";
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public void setRequires(String[] requires) {
        this.requires = requires;
    }
}

