/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config.impl;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.common.apps.config.impl.DynamicConfigPropertyIndexImpl;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DynamicConfigSource
implements ConfigSource {
    private static Optional<DynamicConfigStorage> storage = Optional.empty();
    private static Optional<DynamicConfigPropertyIndexImpl> configIndex = Optional.empty();

    public static void setStorage(DynamicConfigStorage configStorage) {
        storage = Optional.of(configStorage);
    }

    public static void setConfigurationIndex(DynamicConfigPropertyIndexImpl index) {
        configIndex = Optional.of(index);
    }

    public int getOrdinal() {
        return 450;
    }

    public Set<String> getPropertyNames() {
        return Collections.emptySet();
    }

    public String getValue(String propertyName) {
        DynamicConfigPropertyDto dto;
        String pname = this.normalizePropertyName(propertyName);
        if (configIndex.isPresent() && configIndex.get().hasProperty(pname) && storage.isPresent() && (dto = storage.get().getConfigProperty(pname)) != null) {
            return dto.getValue();
        }
        return null;
    }

    private String normalizePropertyName(String propertyName) {
        if (propertyName == null || !propertyName.startsWith("%")) {
            return propertyName;
        }
        int idx = propertyName.indexOf(".");
        if (idx >= propertyName.length()) {
            return propertyName;
        }
        return propertyName.substring(idx + 1);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

