/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config.impl;

import io.apicurio.common.apps.config.DynamicConfigPropertyDef;
import io.apicurio.common.apps.config.DynamicConfigPropertyIndex;
import io.apicurio.common.apps.config.DynamicConfigPropertyList;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
public class DynamicConfigPropertyIndexImpl
implements DynamicConfigPropertyIndex {
    private Map<String, DynamicConfigPropertyDef> propertyIndex;
    @Inject
    DynamicConfigPropertyList properties;
    @Inject
    Config config;

    @PostConstruct
    void onInit() {
        this.indexProperties(this.properties.getDynamicConfigProperties());
    }

    private Map<String, DynamicConfigPropertyDef> getPropertyIndex() {
        return this.propertyIndex;
    }

    private void indexProperties(List<DynamicConfigPropertyDef> dynamicConfigProperties) {
        this.propertyIndex = new HashMap<String, DynamicConfigPropertyDef>(dynamicConfigProperties.size());
        for (DynamicConfigPropertyDef def : dynamicConfigProperties) {
            this.propertyIndex.put(def.getName(), def);
        }
    }

    private boolean accept(DynamicConfigPropertyDef def) {
        ArrayList<CallSite> requires = def.getRequires() == null ? new ArrayList<CallSite>(1) : new ArrayList<String>(Arrays.asList(def.getRequires()));
        requires.add((CallSite)((Object)(def.getName() + ".dynamic.allow=true")));
        Iterator iterator = requires.iterator();
        while (iterator.hasNext()) {
            String require;
            String requiredPropertyName = require = (String)iterator.next();
            String requiredPropertyValue = null;
            if (require.contains("=")) {
                requiredPropertyName = require.substring(0, require.indexOf("=")).trim();
                requiredPropertyValue = require.substring(require.indexOf("=") + 1).trim();
            }
            Optional actualPropertyValue = this.config.getOptionalValue(requiredPropertyName, String.class);
            if (requiredPropertyValue != null && (actualPropertyValue.isEmpty() || !requiredPropertyValue.equals(actualPropertyValue.get()))) {
                return false;
            }
            if (requiredPropertyValue != null || !actualPropertyValue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public DynamicConfigPropertyDef getProperty(String name) {
        return this.getPropertyIndex().get(name);
    }

    public boolean hasProperty(String name) {
        return this.getPropertyIndex().containsKey(name);
    }

    public Set<String> getPropertyNames() {
        return this.getPropertyIndex().keySet();
    }

    public boolean isAccepted(String propertyName) {
        return this.getAcceptedPropertyNames().contains(propertyName);
    }

    public Set<String> getAcceptedPropertyNames() {
        return this.propertyIndex.entrySet().stream().filter(entry -> this.accept((DynamicConfigPropertyDef)entry.getValue())).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }
}

