/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config.impl;

import io.apicurio.common.apps.config.DynamicConfigStorageAccessor;
import io.apicurio.common.apps.config.impl.DynamicConfigPropertyIndexImpl;
import io.apicurio.common.apps.config.impl.DynamicConfigSource;
import io.quarkus.runtime.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class DynamicConfigStartup {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigStartup.class);
    @Inject
    DynamicConfigStorageAccessor configStorageAccessor;
    @Inject
    DynamicConfigPropertyIndexImpl configIndex;

    @PostConstruct
    void onStart() {
        log.debug("Initializing dynamic configuration source in thread {}", (Object)Thread.currentThread().getName());
        this.configStorageAccessor.getConfigStorage().isReady();
        DynamicConfigSource.setStorage(this.configStorageAccessor.getConfigStorage());
        DynamicConfigSource.setConfigurationIndex(this.configIndex);
        log.debug("Dynamic configuration source initialized in thread {}", (Object)Thread.currentThread().getName());
    }
}

