/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config.impl.storage;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigSqlStorageStatements;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.common.apps.config.impl.storage.DynamicConfigPropertyDtoMapper;
import io.apicurio.common.apps.logging.LoggerProducer;
import io.apicurio.common.apps.storage.exceptions.NotFoundException;
import io.apicurio.common.apps.storage.sql.jdbi.HandleFactory;
import io.apicurio.common.apps.storage.sql.jdbi.mappers.RowMapper;
import io.apicurio.common.apps.storage.sql.jdbi.query.Query;
import io.apicurio.common.apps.storage.sql.jdbi.query.Update;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@ApplicationScoped
public class DynamicConfigSqlStorageComponent
implements DynamicConfigStorage {
    public static String RESOURCE_CONTEXT_KEY_DCP = "dynamic configuration property";
    private Logger log;
    private HandleFactory handles;
    private DynamicConfigSqlStorageStatements sqlStatements;
    private volatile boolean isStarting;
    private volatile boolean ready;

    public synchronized void start(LoggerProducer loggerProducer, HandleFactory handles, DynamicConfigSqlStorageStatements sqlStatements) {
        if (this.isStarting) {
            throw new RuntimeException("The DynamicConfigSqlStorageComponent can be started only once");
        }
        this.isStarting = true;
        Objects.requireNonNull(loggerProducer);
        this.log = loggerProducer.getLogger(this.getClass());
        Objects.requireNonNull(handles);
        this.handles = handles;
        Objects.requireNonNull(sqlStatements);
        this.sqlStatements = sqlStatements;
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() {
        this.log.debug("Getting all config properties.");
        return (List)this.handles.withHandleNoExceptionMapped(handle -> {
            String sql = this.sqlStatements.selectConfigProperties();
            return ((Query)handle.createQuery(sql).setContext("resource", RESOURCE_CONTEXT_KEY_DCP)).map((RowMapper)new DynamicConfigPropertyDtoMapper()).list().stream().filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        this.log.debug("Selecting a single config property: {}", (Object)propertyName);
        return (DynamicConfigPropertyDto)this.handles.withHandleNoExceptionMapped(handle -> {
            String sql = this.sqlStatements.selectConfigPropertyByName();
            Optional res = ((Query)((Query)((Query)handle.createQuery(sql).setContext("resource", RESOURCE_CONTEXT_KEY_DCP)).setContext("resource_id", propertyName)).bind(0, propertyName)).map((RowMapper)new DynamicConfigPropertyDtoMapper()).findOne();
            return res.orElse(null);
        });
    }

    public void setConfigProperty(DynamicConfigPropertyDto property) {
        this.log.debug("Setting a config property with name: {}  and value: {}", (Object)property.getName(), (Object)property.getValue());
        this.handles.withHandleNoExceptionMapped(handle -> {
            String propertyName = property.getName();
            String propertyValue = property.getValue();
            String sql = this.sqlStatements.deleteConfigProperty();
            ((Update)((Update)((Update)handle.createUpdate(sql).setContext("resource", RESOURCE_CONTEXT_KEY_DCP)).setContext("resource_id", propertyName)).bind(0, propertyName)).execute();
            sql = this.sqlStatements.insertConfigProperty();
            ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).setContext("resource", RESOURCE_CONTEXT_KEY_DCP)).setContext("resource_id", propertyName)).bind(0, propertyName)).bind(1, propertyValue)).bind(2, Long.valueOf(System.currentTimeMillis()))).execute();
            return null;
        });
    }

    public void deleteConfigProperty(String propertyName) {
        this.log.debug("Deleting a config property from storage: {}", (Object)propertyName);
        this.handles.withHandleNoExceptionMapped(handle -> {
            String sql = this.sqlStatements.deleteConfigProperty();
            int rows = ((Update)((Update)((Update)handle.createUpdate(sql).setContext("resource", RESOURCE_CONTEXT_KEY_DCP)).setContext("resource_id", propertyName)).bind(0, propertyName)).execute();
            if (rows == 0) {
                throw new NotFoundException("Property value not currently set: " + propertyName, Map.of("resource", RESOURCE_CONTEXT_KEY_DCP, "resource_id", propertyName));
            }
            return null;
        });
    }

    protected List<String> getTenantsWithStaleConfigProperties(Instant since) {
        this.log.debug("Getting all tenant IDs with stale config properties.");
        return (List)this.handles.withHandleNoExceptionMapped(handle -> {
            String sql = this.sqlStatements.selectTenantIdsByConfigModifiedOn();
            return ((Query)handle.createQuery(sql).bind(0, Long.valueOf(since.toEpochMilli()))).mapTo(String.class).list();
        });
    }
}

