/*
 * Decompiled with CFR 0.152.
 */
package apicurio.common.app.components.config.index.deployment;

import apicurio.common.app.components.config.index.DynamicPropertiesInfoRecorder;
import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.DynamicConfigPropertyDef;
import io.apicurio.common.apps.config.DynamicConfigPropertyList;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class ConfigIndexProcessor {
    ConfigIndexProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void syntheticBean(DynamicPropertiesInfoRecorder recorder, BeanDiscoveryFinishedBuildItem beanDiscovery, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List dynamicProperties = beanDiscovery.getInjectionPoints().stream().filter(ConfigIndexProcessor::isDynamicConfigProperty).map(injectionPointInfo -> {
            try {
                AnnotationInstance configPropertyAI = injectionPointInfo.getRequiredQualifier(DotName.createSimple((String)ConfigProperty.class.getName()));
                AnnotationInstance dynamicAI = injectionPointInfo.getRequiredQualifier(DotName.createSimple((String)Dynamic.class.getName()));
                Type supplierType = injectionPointInfo.getRequiredType();
                Type actualType = (Type)supplierType.asParameterizedType().arguments().get(0);
                String propertyName = configPropertyAI.value("name").asString();
                Class<?> propertyType = Class.forName(actualType.name().toString());
                AnnotationValue defaultValueAV = configPropertyAI.value("defaultValue");
                if (defaultValueAV == null) {
                    throw new RuntimeException("Dynamic configuration property '" + propertyName + "' must have a default value.");
                }
                String defaultValue = defaultValueAV.asString();
                DynamicConfigPropertyDef def = new DynamicConfigPropertyDef(propertyName, propertyType, defaultValue);
                AnnotationValue labelAV = dynamicAI.value("label");
                AnnotationValue descriptionAV = dynamicAI.value("description");
                AnnotationValue requiresAV = dynamicAI.value("requires");
                if (labelAV != null) {
                    def.setLabel(labelAV.asString());
                }
                if (descriptionAV != null) {
                    def.setDescription(descriptionAV.asString());
                }
                if (requiresAV != null) {
                    def.setRequires(requiresAV.asStringArray());
                }
                return def;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        RuntimeValue dynamicPropertiesHolderRuntimeValue = recorder.initializePropertiesInfo(dynamicProperties);
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DynamicConfigPropertyList.class).runtimeValue(dynamicPropertiesHolderRuntimeValue).unremovable()).setRuntimeInit().done());
    }

    private static boolean isDynamicConfigProperty(InjectionPointInfo injectionPointInfo) {
        return injectionPointInfo.getRequiredQualifier(DotName.createSimple((String)ConfigProperty.class.getName())) != null && injectionPointInfo.isField() && injectionPointInfo.getTarget().asField().annotation(DotName.createSimple((String)Dynamic.class.getName())) != null;
    }
}

