/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.logging.sentry;

import io.quarkus.runtime.StartupEvent;
import io.sentry.Sentry;
import io.sentry.jul.SentryHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.enterprise.event.Observes;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSentryConfiguration {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @ConfigProperty(name="app.enable.sentry", defaultValue="false")
    Boolean enableSentry;

    void onStart(@Observes StartupEvent ev) throws Exception {
        if (this.enableSentry.booleanValue()) {
            System.setProperty("sentry.release", this.getReleaseVersion());
            Sentry.init();
            LogManager manager = org.jboss.logmanager.LogManager.getLogManager();
            manager.getLogger("").addHandler((Handler)new SentryHandler());
            this.log.info("Sentry initialized");
        }
    }

    protected abstract String getReleaseVersion();
}

