/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.logging.audit;

import io.apicurio.common.apps.logging.audit.AuditHttpRequestContext;
import io.apicurio.common.apps.logging.audit.AuditLogService;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Optional;

@Provider
@Priority(value=1000)
@ApplicationScoped
public class HttpRequestsAuditFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    HttpServletRequest request;
    @Inject
    AuditHttpRequestContext auditContext;
    @Inject
    AuditLogService auditLog;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.auditContext.setSourceIp(this.request.getRemoteAddr());
        this.auditContext.setForwardedFor(requestContext.getHeaderString("x-forwarded-for"));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.auditContext.isAuditEntryGenerated()) {
            return;
        }
        if (responseContext.getStatus() >= 400) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("method", requestContext.getMethod());
            metadata.put("path", requestContext.getUriInfo().getPath());
            metadata.put("response_code", String.valueOf(responseContext.getStatus()));
            metadata.put("user", Optional.ofNullable(requestContext.getSecurityContext()).map(SecurityContext::getUserPrincipal).map(Principal::getName).orElseGet(() -> ""));
            this.auditLog.log("apicurio.audit", "request", "failure", metadata, null);
        }
    }
}

