/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.maven;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="merge")
public class MergePropertiesMojo
extends AbstractMojo {
    @Parameter(required=true)
    File output;
    @Parameter(required=true)
    List<File> inputs;
    @Parameter(required=false, defaultValue="false")
    Boolean deleteInputs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.output == null || !this.output.getParentFile().isDirectory() || this.output.isDirectory()) {
            throw new MojoExecutionException("Invalid 'output' file.");
        }
        if (this.inputs == null || this.inputs.isEmpty()) {
            throw new MojoExecutionException("Invalid 'inputs'.  Must be a collection of input files.");
        }
        Properties mergedProps = new Properties();
        this.getLog().info((CharSequence)("Reading " + this.inputs.size() + " input files."));
        for (File input : this.inputs) {
            if (!input.isFile()) {
                throw new MojoExecutionException("Invalid input file: " + input.getAbsolutePath());
            }
            try (FileReader reader = new FileReader(input);){
                Properties inputProps = new Properties();
                inputProps.load(reader);
                mergedProps.putAll((Map<?, ?>)inputProps);
                this.getLog().info((CharSequence)("Read " + inputProps.size() + " properties from input file: " + input.getName()));
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Failed to load input file: " + input.getAbsolutePath(), t);
            }
            if (!this.deleteInputs.booleanValue()) continue;
            input.delete();
            this.getLog().info((CharSequence)("Deleted input file: " + input.getName()));
        }
        if (this.output.isFile()) {
            this.output.delete();
        }
        try (FileWriter writer = new FileWriter(this.output);){
            mergedProps.store(writer, "Properties merged by 'apicurio-common-app-components-maven-plugin'");
            this.getLog().info((CharSequence)("Merged properties written to: " + this.output.getName()));
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Failed to write merged properties to: " + this.output.getAbsolutePath());
        }
    }
}

