/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy;

import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.util.OptionalBean;
import io.apicurio.rest.client.VertxHttpClientProvider;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.tenantmanager.client.TenantManagerClient;
import io.apicurio.tenantmanager.client.TenantManagerClientImpl;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.slf4j.Logger;

public class TenantManagerClientProducer {
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties properties;
    @Inject
    Vertx vertx;

    @Produces
    @ApplicationScoped
    OptionalBean<TenantManagerClient> produce() {
        if (this.properties.isMultitenancyEnabled()) {
            if (this.properties.getTenantManagerUrl().isEmpty()) {
                throw new DeploymentException("Unsupported configuration, \"app.enable.multitenancy\" is enabled but the no \"app.tenant.manager.url\" is provided");
            }
            HashMap<String, String> clientConfigs = new HashMap<String, String>();
            if (this.properties.getTenantManagerCAFilePath().isPresent() && !this.properties.getTenantManagerCAFilePath().get().isBlank()) {
                clientConfigs.put("apicurio.rest.request.ssl.ca-bundle.location", this.properties.getTenantManagerCAFilePath().get());
            }
            OidcAuth auth = null;
            if (this.properties.isTenantManagerAuthEnabled()) {
                if (this.properties.getTenantManagerAuthUrl().isEmpty() || this.properties.getTenantManagerClientId().isEmpty() || this.properties.getTenantManagerClientSecret().isEmpty()) {
                    throw new DeploymentException("Unsupported configuration, \"app.enable.multitenancy\" is enabled \"app.enable.auth\" is enabled but the no auth properties aren't properly configured");
                }
                ApicurioHttpClient httpClient = new VertxHttpClientProvider(this.vertx).create(this.properties.getTenantManagerAuthUrl().get(), Collections.emptyMap(), null, (RestClientErrorHandler)new AuthErrorHandler());
                Duration tokenExpirationReduction = null;
                if (this.properties.getTenantManagerAuthTokenExpirationReductionMs().isPresent()) {
                    this.log.info("Using configured tenant-manager auth token expiration reduction {}", (Object)this.properties.getTenantManagerAuthTokenExpirationReductionMs().get());
                    tokenExpirationReduction = Duration.ofMillis(this.properties.getTenantManagerAuthTokenExpirationReductionMs().get());
                }
                auth = new OidcAuth(httpClient, this.properties.getTenantManagerClientId().get(), this.properties.getTenantManagerClientSecret().get(), tokenExpirationReduction);
            }
            return OptionalBean.of((Object)new TenantManagerClientImpl(this.properties.getTenantManagerUrl().get(), clientConfigs, auth));
        }
        return OptionalBean.empty();
    }
}

