/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy;

import io.apicurio.common.apps.multitenancy.exceptions.TenantForbiddenException;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotAuthorizedException;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotFoundException;
import io.apicurio.common.apps.util.OptionalBean;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.NewApicurioTenantRequest;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.apicurio.tenantmanager.api.datamodel.UpdateApicurioTenantRequest;
import io.apicurio.tenantmanager.client.TenantManagerClient;
import io.apicurio.tenantmanager.client.exception.ApicurioTenantNotFoundException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@ApplicationScoped
public class TenantManagerService {
    @Inject
    OptionalBean<TenantManagerClient> tenantManagerClient;

    @Retry(abortOn={UnsupportedOperationException.class, TenantNotFoundException.class, TenantNotAuthorizedException.class, TenantForbiddenException.class})
    @Timeout(value=5000L)
    public ApicurioTenant createTenant(NewApicurioTenantRequest tenantRequest) throws TenantNotFoundException {
        if (this.tenantManagerClient.isEmpty()) {
            throw new UnsupportedOperationException("Multitenancy is not enabled");
        }
        try {
            return ((TenantManagerClient)this.tenantManagerClient.get()).createTenant(tenantRequest);
        }
        catch (ApicurioTenantNotFoundException e) {
            throw new TenantNotFoundException(e.getMessage());
        }
        catch (NotAuthorizedException e) {
            throw new TenantNotAuthorizedException(e.getMessage());
        }
        catch (ForbiddenException e) {
            throw new TenantForbiddenException(e.getMessage());
        }
    }

    @Retry(abortOn={UnsupportedOperationException.class, TenantNotFoundException.class, TenantNotAuthorizedException.class, TenantForbiddenException.class})
    @Timeout(value=5000L)
    public ApicurioTenant getTenant(String tenantId) throws TenantNotFoundException {
        if (this.tenantManagerClient.isEmpty()) {
            throw new UnsupportedOperationException("Multitenancy is not enabled");
        }
        try {
            return ((TenantManagerClient)this.tenantManagerClient.get()).getTenant(tenantId);
        }
        catch (ApicurioTenantNotFoundException e) {
            throw new TenantNotFoundException(e.getMessage());
        }
        catch (NotAuthorizedException e) {
            throw new TenantNotAuthorizedException(e.getMessage());
        }
        catch (ForbiddenException e) {
            throw new TenantForbiddenException(e.getMessage());
        }
    }

    @Retry(abortOn={UnsupportedOperationException.class, TenantNotFoundException.class, TenantNotAuthorizedException.class, TenantForbiddenException.class})
    @Timeout(value=5000L)
    public void markTenantAsDeleted(String tenantId) {
        if (this.tenantManagerClient.isEmpty()) {
            throw new UnsupportedOperationException("Multitenancy is not enabled");
        }
        try {
            UpdateApicurioTenantRequest ureq = new UpdateApicurioTenantRequest();
            ureq.setStatus(TenantStatusValue.DELETED);
            ((TenantManagerClient)this.tenantManagerClient.get()).updateTenant(tenantId, ureq);
        }
        catch (ApicurioTenantNotFoundException e) {
            throw new TenantNotFoundException(e.getMessage());
        }
        catch (NotAuthorizedException e) {
            throw new TenantNotAuthorizedException(e.getMessage());
        }
        catch (ForbiddenException e) {
            throw new TenantForbiddenException(e.getMessage());
        }
    }
}

