/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy;

import io.apicurio.common.apps.config.Info;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class MultitenancyProperties {
    @Inject
    @ConfigProperty(name="app.enable.multitenancy", defaultValue="false")
    @Info(category="mt", description="Enable multitenancy", registryAvailableSince="2.0.0.Final", availableSince="0.1.19.Final")
    boolean multitenancyEnabled;
    @Inject
    @ConfigProperty(name="app.enable.multitenancy.standalone", defaultValue="false")
    @Info(category="mt", description="Enable Standalone Multitenancy mode. In this mode, Registry provides basic multi-tenancy features, without dependencies on additional components to manage tenants and their metadata. A new tenant is simply created as soon as a tenant ID is extracted from the request for the first time. The tenant IDs must be managed externally, and tenants can be effectively deleted by deleting their data.", dependsOn={"app.enable.multitenancy"}, registryAvailableSince="2.5.0.Final", availableSince="0.1.21.Final")
    boolean standaloneMultitenancyEnabled;
    @Inject
    @ConfigProperty(name="app.multitenancy.authorization.enabled", defaultValue="true")
    @Info(category="mt", description="Enable multitenancy authorization", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    boolean mtAuthorizationEnabled;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.context-path.enabled", defaultValue="true")
    @Info(category="mt", description="Enable multitenancy context path type", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    boolean mtContextPathEnabled;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.subdomain.enabled", defaultValue="false")
    @Info(category="mt", description="Enable multitenancy subdomain type", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    boolean mtSubdomainEnabled;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.request-header.enabled", defaultValue="true")
    @Info(category="mt", description="Enable multitenancy request header type", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    boolean mtRequestHeaderEnabled;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.token-claims.enabled", defaultValue="false")
    @Info(category="mt", description="Enable multitenancy request header type", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    boolean mtTokenClaimsEnabled;
    @ConfigProperty(name="app.multitenancy.tenant.token-claim.names")
    @Info(category="mt", description="Token claims used to resolve the tenant id", availableSince="2.1.0.Final")
    List<String> tenantTokenClaims;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.context-path.base-path", defaultValue="t")
    @Info(category="mt", description="Multitenancy context path type base path", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    String nameMultitenancyBasePath;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.subdomain.location", defaultValue="header")
    @Info(category="mt", description="Multitenancy subdomain type location", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    String subdomainMultitenancyLocation;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.subdomain.header-name", defaultValue="Host")
    @Info(category="mt", description="Multitenancy subdomain type header name", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    String subdomainMultitenancyHeaderName;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.subdomain.pattern", defaultValue="(\\w[\\w\\d\\-]*)\\.localhost\\.local")
    @Info(category="mt", description="Multitenancy subdomain type pattern", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    String subdomainMultitenancyPattern;
    @Inject
    @ConfigProperty(name="app.multitenancy.types.request-header.name", defaultValue="X-Tenant-Id")
    @Info(category="mt", description="Multitenancy request header type name", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    String tenantIdRequestHeader;
    @Inject
    @ConfigProperty(name="app.multitenancy.reaper.every")
    @Info(category="mt", description="Multitenancy reaper every", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Optional<String> reaperEvery;
    @Inject
    @ConfigProperty(name="app.multitenancy.reaper.period-seconds", defaultValue="10800")
    @Info(category="mt", description="Multitenancy reaper period seconds", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Long reaperPeriodSeconds;
    @Inject
    @ConfigProperty(name="app.tenant.manager.url")
    @Info(category="mt", description="Tenant manager URL", registryAvailableSince="2.0.0.Final", availableSince="0.1.19.Final")
    Optional<String> tenantManagerUrl;
    @Inject
    @ConfigProperty(name="app.tenant.manager.ssl.ca.path")
    @Info(category="mt", description="Tenant manager SSL Ca path", registryAvailableSince="2.2.0.Final", availableSince="0.1.19.Final")
    Optional<String> tenantManagerCAFilePath;
    @Inject
    @ConfigProperty(name="app.tenant.manager.auth.enabled")
    @Info(category="mt", description="Tenant manager auth enabled", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Optional<Boolean> tenantManagerAuthEnabled;
    @Inject
    @ConfigProperty(name="app.tenant.manager.auth.url.configured")
    @Info(category="mt", description="Tenant manager auth url configured", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Optional<String> tenantManagerAuthUrl;
    @Inject
    @ConfigProperty(name="app.tenant.manager.auth.client-id")
    @Info(category="mt", description="Tenant manager auth client ID", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Optional<String> tenantManagerClientId;
    @Inject
    @ConfigProperty(name="app.tenant.manager.auth.client-secret")
    @Info(category="mt", description="Tenant manager auth client secret", registryAvailableSince="2.1.0.Final", availableSince="0.1.19.Final")
    Optional<String> tenantManagerClientSecret;
    @Inject
    @ConfigProperty(name="app.tenant.manager.auth.token.expiration.reduction.ms")
    @Info(category="mt", description="Tenant manager auth token expiration reduction ms", registryAvailableSince="2.2.0.Final", availableSince="0.1.19.Final")
    Optional<Long> tenantManagerAuthTokenExpirationReductionMs;

    @PostConstruct
    void init() {
        this.reaperEvery.orElseThrow(() -> new IllegalArgumentException("Missing required configuration property 'app.multitenancy.reaper.every'"));
    }

    public boolean isMultitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    public boolean isStandaloneMultitenancyEnabled() {
        return this.standaloneMultitenancyEnabled;
    }

    public boolean isMultitenancyAuthorizationEnabled() {
        return this.mtAuthorizationEnabled;
    }

    public boolean isMultitenancyContextPathEnabled() {
        return this.mtContextPathEnabled;
    }

    public boolean isMultitenancySubdomainEnabled() {
        return this.mtSubdomainEnabled;
    }

    public boolean isMultitenancyRequestHeaderEnabled() {
        return this.mtRequestHeaderEnabled;
    }

    public boolean isMultitenancyTokenClaimsEnabled() {
        return this.mtTokenClaimsEnabled;
    }

    public String getNameMultitenancyBasePath() {
        return this.nameMultitenancyBasePath;
    }

    public String getSubdomainMultitenancyLocation() {
        return this.subdomainMultitenancyLocation;
    }

    public String getSubdomainMultitenancyHeaderName() {
        return this.subdomainMultitenancyHeaderName;
    }

    public String getSubdomainMultitenancyPattern() {
        return this.subdomainMultitenancyPattern;
    }

    public List<String> getTenantIdClaims() {
        return this.tenantTokenClaims;
    }

    public String getTenantIdRequestHeader() {
        return this.tenantIdRequestHeader;
    }

    public Duration getReaperPeriod() {
        return Duration.ofSeconds(this.reaperPeriodSeconds);
    }

    public Optional<String> getTenantManagerUrl() {
        return this.tenantManagerUrl;
    }

    public Optional<String> getTenantManagerCAFilePath() {
        return this.tenantManagerCAFilePath;
    }

    public boolean isTenantManagerAuthEnabled() {
        return this.tenantManagerAuthEnabled.orElse(Boolean.FALSE);
    }

    public Optional<String> getTenantManagerAuthUrl() {
        return this.tenantManagerAuthUrl;
    }

    public Optional<String> getTenantManagerClientId() {
        return this.tenantManagerClientId;
    }

    public Optional<String> getTenantManagerClientSecret() {
        return this.tenantManagerClientSecret;
    }

    public Optional<Long> getTenantManagerAuthTokenExpirationReductionMs() {
        return this.tenantManagerAuthTokenExpirationReductionMs;
    }
}

