/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy;

import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantIdResolver {
    private static final int TENANT_ID_POSITION = 2;
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    Instance<JsonWebToken> jsonWebToken;
    Pattern subdomainNamePattern;
    String multitenancyBasePath;

    void init(@Observes StartupEvent ev) {
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.info("Application running with multitenancy enabled");
        }
        this.multitenancyBasePath = "/" + this.mtProperties.getNameMultitenancyBasePath() + "/";
        if (this.mtProperties.isMultitenancySubdomainEnabled()) {
            this.subdomainNamePattern = Pattern.compile(this.mtProperties.getSubdomainMultitenancyPattern());
        }
    }

    public Optional<String> resolveTenantId(String uri, Function<String, String> headerProvider, Supplier<String> serverNameProvider, Consumer<String> afterSuccessfullUrlResolution) {
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.trace("Resolving tenantId...");
            if (this.mtProperties.isMultitenancyContextPathEnabled()) {
                this.log.trace("Resolving tenantId from path: {}", (Object)uri);
                if (uri.startsWith(this.multitenancyBasePath)) {
                    String[] tokens = uri.split("/");
                    String tenantId = tokens[2];
                    if (afterSuccessfullUrlResolution != null) {
                        afterSuccessfullUrlResolution.accept(tenantId);
                    }
                    return Optional.of(tenantId);
                }
                this.log.warn("Context-path multi-tenancy enabled.  Detected unmatched path.");
            }
            if (this.mtProperties.isMultitenancySubdomainEnabled()) {
                this.log.trace("Resolving tenantId from subdomain.");
                String domain = null;
                String domainLocation = this.mtProperties.getSubdomainMultitenancyLocation();
                if (domainLocation.equals("header")) {
                    String domainHeaderName = this.mtProperties.getSubdomainMultitenancyHeaderName();
                    domain = headerProvider.apply(domainHeaderName);
                } else if (domainLocation.equals("serverName")) {
                    domain = serverNameProvider.get();
                } else {
                    this.log.warn("Unknown domain location: " + domainLocation);
                    domain = "";
                }
                Matcher matcher = this.subdomainNamePattern.matcher(domain);
                if (matcher.matches()) {
                    String tenantId = matcher.group(1);
                    if (tenantId != null) {
                        return Optional.of(tenantId);
                    }
                } else {
                    this.log.warn("Subdomain multi-tenancy enabled.  Detected unmatched domain: " + domain);
                }
            }
            if (this.mtProperties.isMultitenancyRequestHeaderEnabled()) {
                String headerName = this.mtProperties.getTenantIdRequestHeader();
                this.log.trace("Resolving tenantId from request header named: {}", (Object)headerName);
                String tenantId = headerProvider.apply(headerName);
                if (tenantId != null) {
                    return Optional.of(tenantId);
                }
                this.log.warn("Request header multi-tenancy enabled, but header value not found in request.");
            }
            if (this.mtProperties.isMultitenancyTokenClaimsEnabled()) {
                for (String tenantIdClaim : this.mtProperties.getTenantIdClaims()) {
                    this.log.trace("Resolving tenantId from token claim named: {}", (Object)tenantIdClaim);
                    Optional claimValue = ((JsonWebToken)this.jsonWebToken.get()).claim(tenantIdClaim);
                    if (!claimValue.isPresent()) continue;
                    return Optional.of((String)claimValue.get());
                }
            }
        }
        return Optional.empty();
    }

    public int tenantPrefixLength(String tenantId) {
        return (this.multitenancyBasePath + tenantId).length();
    }
}

