/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy.context;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.ApicurioTenantContext;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContextLoader;
import io.apicurio.common.apps.multitenancy.TenantManagerService;
import io.apicurio.common.apps.multitenancy.context.ApicurioTenantContextImpl;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotFoundException;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsConfiguration;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsConfigurationService;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.common.constraint.NotNull;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantContextLoaderImpl
implements TenantContextLoader {
    private LoadingCache<String, ApicurioTenantContext> contextsCache;
    private ApicurioTenantContext defaultTenantContext;
    @Inject
    TenantManagerService tenantMetadataService;
    @Inject
    TenantLimitsConfigurationService limitsConfigurationService;
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(defaultValue="60000", name="app.tenants.context.cache.check-period")
    @Info(category="mt", description="Tenants context cache check period", availableSince="2.1.0.Final")
    Long cacheCheckPeriod;
    @Inject
    @ConfigProperty(defaultValue="1000", name="app.tenants.context.cache.max-size")
    @Info(category="mt", description="Tenants context cache max size", availableSince="2.4.1.Final")
    Long cacheMaxSize;
    @Inject
    MultitenancyProperties properties;

    public void onStart(@Observes StartupEvent ev) {
        this.contextsCache = CacheBuilder.newBuilder().expireAfterWrite(this.cacheCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.getCacheLoader());
    }

    private CacheLoader<String, ApicurioTenantContext> getCacheLoader() {
        CacheLoader<String, ApicurioTenantContext> standaloneLoader = new CacheLoader<String, ApicurioTenantContext>(){

            public ApicurioTenantContext load(@NotNull String tenantId) {
                ApicurioTenant tenantMetadata = new ApicurioTenant();
                tenantMetadata.setStatus(TenantStatusValue.READY);
                tenantMetadata.setTenantId(tenantId);
                tenantMetadata.setOrganizationId(tenantId);
                tenantMetadata.setCreatedBy(tenantId);
                tenantMetadata.setName(tenantId);
                TenantLimitsConfiguration limitsConfiguration = TenantContextLoaderImpl.this.limitsConfigurationService.fromTenantMetadata(tenantMetadata);
                return new ApicurioTenantContextImpl(tenantId, tenantMetadata.getCreatedBy(), limitsConfiguration, tenantMetadata.getStatus(), String.valueOf(tenantMetadata.getOrganizationId()));
            }
        };
        CacheLoader<String, ApicurioTenantContext> remoteLoader = new CacheLoader<String, ApicurioTenantContext>(){

            public ApicurioTenantContext load(@NotNull String tenantId) {
                ApicurioTenant tenantMetadata = TenantContextLoaderImpl.this.tenantMetadataService.getTenant(tenantId);
                TenantLimitsConfiguration limitsConfiguration = TenantContextLoaderImpl.this.limitsConfigurationService.fromTenantMetadata(tenantMetadata);
                return new ApicurioTenantContextImpl(tenantId, tenantMetadata.getCreatedBy(), limitsConfiguration, tenantMetadata.getStatus(), String.valueOf(tenantMetadata.getOrganizationId()));
            }
        };
        if (this.properties.isStandaloneMultitenancyEnabled()) {
            return standaloneLoader;
        }
        return remoteLoader;
    }

    public ApicurioTenantContext loadBatchJobContext(String tenantId) {
        return this.loadRequestContext(tenantId);
    }

    public ApicurioTenantContext loadRequestContext(String tenantId) {
        if (tenantId.equals("_")) {
            return this.defaultTenantContext();
        }
        try {
            return (ApicurioTenantContext)this.contextsCache.get((Object)tenantId);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof TenantNotFoundException) {
                throw (TenantNotFoundException)e.getCause();
            }
            this.log.warn("Error trying to load the tenant context for tenant id: {}.", (Object)tenantId, (Object)e);
            throw new TenantNotFoundException(tenantId);
        }
    }

    public ApicurioTenantContext defaultTenantContext() {
        if (this.defaultTenantContext == null) {
            this.defaultTenantContext = new ApicurioTenantContextImpl("_", null, this.limitsConfigurationService.defaultConfigurationTenant(), TenantStatusValue.READY, null);
        }
        return this.defaultTenantContext;
    }

    public void invalidateTenantInCache(String tenantId) {
        this.contextsCache.invalidate((Object)tenantId);
    }

    public void invalidateTenantCache() {
        this.contextsCache.invalidateAll();
    }
}

