/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.storage.exceptions;

import java.util.Map;
import java.util.Optional;

public class StorageException
extends Exception {
    private static final long serialVersionUID = 7551763806044016474L;
    protected Optional<Map<String, String>> context = Optional.empty();

    public StorageException(String reason, Map<String, String> context) {
        super(reason);
        this.context = Optional.ofNullable(context);
    }

    public StorageException(Map<String, String> context, Throwable cause) {
        super(cause);
        this.context = Optional.ofNullable(context);
    }

    public StorageException(String reason, Map<String, String> context, Throwable cause) {
        super(reason, cause);
        this.context = Optional.ofNullable(context);
    }

    public boolean isRoot() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + Optional.ofNullable(super.toString()).orElse("<no reason>") + this.context.filter(m -> !m.isEmpty()).map(c -> " with context " + c).orElse(" with no context");
    }

    public Optional<Map<String, String>> getContext() {
        return this.context;
    }
}

