/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.web.filters;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApplicationScoped
public class HSTSFilter
implements Filter {
    private static final long MAX_AGE = 31536000L;
    private static final String HSTS_HEADER = "max-age=31536000; includeSubdomains";

    public static void addHstsHeaders(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Strict-Transport-Security", HSTS_HEADER);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HSTSFilter.addHstsHeaders(httpResponse);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

