/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.web.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public abstract class RedirectFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.isEnabled()) {
            Map<String, String> redirects;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            if (servletPath == null || "".equals(servletPath) || "/".equals(servletPath)) {
                servletPath = "/";
            }
            if ((redirects = this.getRedirects()).containsKey(servletPath)) {
                response.sendRedirect(redirects.get(servletPath));
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }

    protected abstract boolean isEnabled();

    protected abstract Map<String, String> getRedirects();
}

