/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.web.servlets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

public abstract class ConfigJsServlet
extends HttpServlet {
    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ct = "application/javascript; charset=" + StandardCharsets.UTF_8;
        response.setContentType(ct);
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator generator = factory.createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
            String varName = this.getVarName();
            String varDecl = "var " + varName + " = ";
            response.getOutputStream().write(varDecl.getBytes("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            generator.setCodec((ObjectCodec)mapper);
            generator.useDefaultPrettyPrinter();
            Object config = this.generateConfig(request);
            generator.writeObject(config);
            generator.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected abstract String getVarName();

    protected abstract Object generateConfig(HttpServletRequest var1);

    protected String generateApiUrl(HttpServletRequest request) {
        try {
            String apiUrl = this.getApiUrlOverride();
            if (apiUrl == null) {
                String apiRelativePath = this.getApiRelativePath();
                String url = ConfigJsServlet.resolveUrlFromXForwarded(request, apiRelativePath);
                if (url != null) {
                    return url;
                }
                url = request.getRequestURL().toString();
                if ((url = new URI(url).resolve(apiRelativePath).toString()).startsWith("http:") && request.isSecure()) {
                    url = url.replaceFirst("http", "https");
                }
                return url;
            }
            return apiUrl;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getApiUrlOverride();

    protected abstract String getApiRelativePath();

    protected static String resolveUrlFromXForwarded(HttpServletRequest request, String path) {
        try {
            String fproto = request.getHeader("X-Forwarded-Proto");
            String fhost = request.getHeader("X-Forwarded-Host");
            if (!ConfigJsServlet.isEmpty(fproto) && !ConfigJsServlet.isEmpty(fhost)) {
                return new URI(fproto + "://" + fhost).resolve(path).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

