/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.rest.client.auth.AccessTokenResponse;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.request.TokenRequestsProvider;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientProvider;
import io.apicurio.rest.client.spi.ApicurioHttpClientServiceLoader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OidcAuth
implements Auth {
    private static final String BEARER = "Bearer ";
    private static final String CLIENT_CREDENTIALS_GRANT = "client_credentials";
    private static final String PASSWORD_GRANT = "password";
    private static final ApicurioHttpClientServiceLoader serviceLoader = new ApicurioHttpClientServiceLoader();
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private String cachedAccessToken;
    private long cachedAccessTokenExp;
    private final ApicurioHttpClient apicurioHttpClient;

    public OidcAuth(String tokenEndpoint, String clientId, String clientSecret, Optional<RestClientErrorHandler> optionalErrorHandler) {
        if (!((String)tokenEndpoint).endsWith("/")) {
            tokenEndpoint = (String)tokenEndpoint + "/";
        }
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.apicurioHttpClient = this.resolveApicurioHttpClient(optionalErrorHandler.orElse(new AuthErrorHandler()));
    }

    public OidcAuth(ApicurioHttpClientProvider httpClientProvider, String tokenEndpoint, String clientId, String clientSecret, Optional<RestClientErrorHandler> optionalErrorHandler) {
        if (!((String)tokenEndpoint).endsWith("/")) {
            tokenEndpoint = (String)tokenEndpoint + "/";
        }
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.apicurioHttpClient = httpClientProvider.create((String)tokenEndpoint, Collections.emptyMap(), null, optionalErrorHandler.orElse(new AuthErrorHandler()));
    }

    private static ApicurioHttpClientProvider resolveProviderInstance() {
        return serviceLoader.providers(true).next();
    }

    private ApicurioHttpClient resolveApicurioHttpClient(RestClientErrorHandler errorHandler) {
        return OidcAuth.resolveProviderInstance().create(this.tokenEndpoint, Collections.emptyMap(), null, errorHandler);
    }

    @Override
    public void apply(Map<String, String> requestHeaders) {
        if (this.isAccessTokenRequired()) {
            this.requestAccessToken();
        }
        requestHeaders.put("Authorization", BEARER + this.cachedAccessToken);
    }

    private void requestAccessToken() {
        try {
            Map<String, String> params = Map.of("grant_type", CLIENT_CREDENTIALS_GRANT, "client_id", this.clientId, "client_secret", this.clientSecret);
            String paramsEncoded = params.entrySet().stream().map(entry -> String.join((CharSequence)"=", URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
            AccessTokenResponse accessTokenResponse = this.apicurioHttpClient.sendRequest(TokenRequestsProvider.obtainAccessToken(paramsEncoded));
            this.cachedAccessToken = accessTokenResponse.getToken();
            this.cachedAccessTokenExp = System.currentTimeMillis() / 1000L + accessTokenResponse.getExpiresIn();
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error found while trying to request a new token");
        }
    }

    public String authenticate() {
        if (this.isAccessTokenRequired()) {
            this.requestAccessToken();
        }
        return this.cachedAccessToken;
    }

    public String obtainAccessTokenWithBasicCredentials(String username, String password) {
        try {
            Map<String, String> params = Map.of("grant_type", PASSWORD_GRANT, "client_id", this.clientId, "client_secret", this.clientSecret, "username", username, PASSWORD_GRANT, password);
            String paramsEncoded = params.entrySet().stream().map(entry -> String.join((CharSequence)"=", URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
            return this.apicurioHttpClient.sendRequest(TokenRequestsProvider.obtainAccessToken(paramsEncoded)).getToken();
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error found while trying to request a new token");
        }
    }

    private boolean isAccessTokenRequired() {
        return null == this.cachedAccessToken || this.isTokenExpired();
    }

    private boolean isTokenExpired() {
        return (long)((int)(System.currentTimeMillis() / 1000L)) > this.cachedAccessTokenExp;
    }
}

