/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client;

import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.handler.BodyHandler;
import io.apicurio.rest.client.request.Request;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.util.UriUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JdkHttpClient
implements ApicurioHttpClient {
    private HttpClient client;
    private final String endpoint;
    private final Auth auth;
    private final RestClientErrorHandler errorHandler;
    private final ExecutorService executor;
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final ThreadLocal<Map<String, String>> requestHeaders = ThreadLocal.withInitial(Collections::emptyMap);

    public JdkHttpClient(String endpoint, Map<String, Object> configs, Auth auth, RestClientErrorHandler errorHandler) {
        Object disableAutoBasePathAppend;
        if (!((String)endpoint).endsWith("/")) {
            endpoint = (String)endpoint + "/";
        }
        if (!JdkHttpClient.toBoolean(disableAutoBasePathAppend = configs.get("apicurio.rest.client.disable-auto-basepath-append")) && !((String)endpoint).endsWith(String.valueOf(configs.get("apicurio.rest.client.auto-base-path")))) {
            endpoint = (String)endpoint + configs.getOrDefault("apicurio.rest.client.auto-base-path", "");
        }
        HttpClient.Builder httpClientBuilder = JdkHttpClient.handleConfiguration(configs);
        this.endpoint = endpoint;
        this.auth = auth;
        this.executor = Executors.newFixedThreadPool(5);
        this.client = httpClientBuilder.executor(this.executor).build();
        this.errorHandler = errorHandler;
    }

    private static HttpClient.Builder handleConfiguration(Map<String, Object> configs) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        clientBuilder.version(HttpClient.Version.HTTP_1_1);
        JdkHttpClient.addHeaders(configs);
        clientBuilder = JdkHttpClient.addSSL(clientBuilder, configs);
        return clientBuilder;
    }

    private static void addHeaders(Map<String, Object> configs) {
        Map<String, String> requestHeaders = configs.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith("apicurio.rest.request.headers.")).collect(Collectors.toMap(map -> ((String)map.getKey()).replace("apicurio.rest.request.headers.", ""), map -> map.getValue().toString()));
        if (!requestHeaders.isEmpty()) {
            requestHeaders.forEach(DEFAULT_HEADERS::put);
        }
    }

    private static HttpClient.Builder addSSL(HttpClient.Builder httpClientBuilder, Map<String, Object> configs) {
        try {
            KeyManager[] keyManagers = JdkHttpClient.getKeyManagers(configs);
            Object[] trustManagers = JdkHttpClient.getTrustManagers(configs);
            if (!(trustManagers == null || trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("A single X509TrustManager is expected. Unexpected trust managers: " + Arrays.toString(trustManagers));
            }
            if (keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(keyManagers, (TrustManager[])trustManagers, new SecureRandom());
                return httpClientBuilder.sslContext(sslContext);
            }
            return httpClientBuilder;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TrustManager[] getTrustManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        TrustManager[] trustManagers = null;
        if (configs.containsKey("apicurio.rest.request.ssl.truststore.location")) {
            String truststoreType = (String)configs.getOrDefault("apicurio.rest.request.ssl.truststore.type", "JKS");
            KeyStore truststore = KeyStore.getInstance(truststoreType);
            String truststorePwd = (String)configs.getOrDefault("apicurio.rest.request.ssl.truststore.password", "");
            truststore.load(new FileInputStream((String)configs.get("apicurio.rest.request.ssl.truststore.location")), truststorePwd.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private static KeyManager[] getKeyManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (configs.containsKey("apicurio.rest.request.ssl.keystore.location")) {
            String keystoreType = (String)configs.getOrDefault("apicurio.rest.request.ssl.keystore.type", "JKS");
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            String keyStorePwd = (String)configs.getOrDefault("apicurio.rest.request.ssl.keystore.password", "");
            keystore.load(new FileInputStream((String)configs.get("apicurio.rest.request.ssl.keystore.location")), keyStorePwd.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyPwd = (String)configs.getOrDefault("apicurio.rest.request.ssl.key.password", keyStorePwd);
            keyManagerFactory.init(keystore, keyPwd.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        return keyManagers;
    }

    public <T> T sendRequest(Request<T> request) {
        try {
            Objects.requireNonNull(request.getOperation(), "Request operation cannot be null");
            Objects.requireNonNull(request.getResponseType(), "Response type cannot be null");
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(UriUtil.buildURI((String)(this.endpoint + request.getRequestPath()), (Map)request.getQueryParams(), (List)request.getPathParams()));
            DEFAULT_HEADERS.forEach(requestBuilder::header);
            requestHeaders.get().forEach(requestBuilder::header);
            requestHeaders.remove();
            HashMap<String, String> headers = request.getHeaders();
            if (this.auth != null) {
                headers = new HashMap<String, String>(headers);
                this.auth.apply(headers);
            }
            headers.forEach(requestBuilder::header);
            switch (request.getOperation()) {
                case GET: {
                    requestBuilder.GET();
                    break;
                }
                case PUT: {
                    requestBuilder.PUT(HttpRequest.BodyPublishers.ofByteArray(request.getData().readAllBytes()));
                    break;
                }
                case POST: {
                    if (request.getDataString() != null) {
                        requestBuilder.POST(HttpRequest.BodyPublishers.ofString(request.getDataString()));
                        break;
                    }
                    requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(request.getData().readAllBytes()));
                    break;
                }
                case DELETE: {
                    requestBuilder.DELETE();
                    break;
                }
                default: {
                    throw new IllegalStateException("Operation not allowed");
                }
            }
            return ((Supplier)this.client.send(requestBuilder.build(), new BodyHandler(request.getResponseType(), this.errorHandler)).body()).get();
        }
        catch (IOException | InterruptedException e) {
            throw this.errorHandler.parseError(e);
        }
    }

    public void setNextRequestHeaders(Map<String, String> headers) {
        requestHeaders.set(headers);
    }

    public Map<String, String> getHeaders() {
        return requestHeaders.get();
    }

    private static boolean toBoolean(Object parameter) {
        if (parameter == null) {
            return false;
        }
        if (parameter instanceof Boolean) {
            return (Boolean)parameter;
        }
        if (parameter instanceof String) {
            return Boolean.parseBoolean((String)parameter);
        }
        return false;
    }

    public void close() {
        if (!this.executor.isShutdown() && !this.executor.isTerminated()) {
            this.executor.shutdown();
        }
        this.client = null;
    }
}

